/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import java.util.Arrays;

public class Slice
implements RMDataStructure,
Comparable<Slice> {
    private final byte[] storedData;

    private Slice(byte[] storedData) {
        if (storedData == null) {
            throw new NullPointerException("Null data");
        }
        this.storedData = storedData;
    }

    public static Slice create(byte[] data) {
        return new Slice(data);
    }

    public static Slice create(String data) {
        return Slice.create((byte[])data.getBytes().clone());
    }

    public byte[] data() {
        return Arrays.copyOf(this.storedData, this.storedData.length);
    }

    public int length() {
        return this.data().length;
    }

    public String toString() {
        return new String(this.data());
    }

    public boolean equals(Object b) {
        return b instanceof Slice && Arrays.equals(this.data(), ((Slice)b).data());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data());
    }

    @Override
    public void raiseTypeCastException() {
        throw new WrongValueTypeException("WRONGTYPE Slice value is used in the wrong place");
    }

    @Override
    public String getTypeName() {
        return "string";
    }

    @Override
    public int compareTo(Slice b) {
        int len1 = this.data().length;
        int len2 = b.data().length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte b2;
            byte b1 = this.data()[k];
            if (b1 == (b2 = b.data()[k])) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }
}

