/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.hyperloglog;

import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RedisCommand(value="pfmerge")
class PFMerge
extends AbstractRedisOperation {
    PFMerge(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        boolean first;
        Set<Slice> set;
        Slice key = this.params().get(0);
        RMSet rmData = this.base().getSet(key);
        if (rmData == null) {
            set = new HashSet<Slice>();
            first = true;
        } else {
            set = rmData.getStoredData();
            first = false;
        }
        for (Slice v : this.params().subList(1, this.params().size())) {
            RMSet valueToMerge = this.base().getSet(v);
            if (valueToMerge == null) continue;
            Set<Slice> s = valueToMerge.getStoredData();
            set.addAll(s);
        }
        if (first) {
            this.base().putValue(key, new RMSet(set));
        }
        return Response.OK;
    }
}

