/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMHMap;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@RedisCommand(value="zrange")
class ZRange
extends AbstractRedisOperation {
    private static final String WITH_SCORES = "WITHSCORES";

    ZRange(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMHMap mapDBObj = this.getHMapFromBaseOrCreateEmpty(key);
        Map<Slice, Double> map = mapDBObj.getStoredData();
        int start = Utils.convertToInteger(this.params().get(1).toString());
        int end = Utils.convertToInteger(this.params().get(2).toString());
        if (start < 0 && (start = map.size() + start) < 0) {
            start = 0;
        }
        if (end < 0 && (end = map.size() + end) < 0) {
            end = -1;
        }
        if (end >= map.size()) {
            end = map.size() - 1;
        }
        boolean withScores = this.params().size() == 4 && WITH_SCORES.equalsIgnoreCase(this.params().get(3).toString());
        List<Slice> values = map.entrySet().stream().skip(start).limit(end - start + 1).flatMap(e -> withScores ? Stream.of((Slice)e.getKey(), Slice.create(((Double)e.getValue()).toString())) : Stream.of(e.getKey())).map(Response::bulkString).collect(Collectors.toList());
        return Response.array(values);
    }
}

