/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMHMap;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@RedisCommand(value="zrangebylex")
class ZRangeByLex
extends AbstractRedisOperation {
    static final String NEGATIVELY_INFINITE = "-";
    static final String POSITIVELY_INFINITE = "+";
    static final String INCLUSIVE_PREFIX = "[";
    static final String EXCLUSIVE_PREFIX = "(";

    ZRangeByLex(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMHMap mapDBObj = this.getHMapFromBaseOrCreateEmpty(key);
        Map<Slice, Double> map = mapDBObj.getStoredData();
        String start = this.params().get(1).toString();
        if (!this.validateStart(start)) {
            return this.buildErrorResponse("start");
        }
        String end = this.params().get(2).toString();
        if (!this.validateEnd(end)) {
            return this.buildErrorResponse("end");
        }
        return Response.array(this.doProcess(map, start, end));
    }

    private Slice buildErrorResponse(String param) {
        return Response.error("Valid " + param + " must start with '" + INCLUSIVE_PREFIX + "' or '" + EXCLUSIVE_PREFIX + "' or unbounded");
    }

    protected boolean validateStart(String start) {
        return this.getStartUnbounded().equals(start) || this.startsWithAnyPrefix(start);
    }

    protected boolean validateEnd(String end) {
        return this.getEndUnbounded().equals(end) || this.startsWithAnyPrefix(end);
    }

    protected boolean startsWithAnyPrefix(String s) {
        return s.startsWith(INCLUSIVE_PREFIX) || s.startsWith(EXCLUSIVE_PREFIX);
    }

    protected List<Slice> doProcess(Map<Slice, Double> map, String start, String end) {
        return map.keySet().stream().filter(this.buildStartPredicate(start).and(this.buildEndPredicate(end))).sorted().map(Response::bulkString).collect(Collectors.toList());
    }

    protected Predicate<Slice> buildStartPredicate(String start) {
        return p -> this.getStartUnbounded().equals(start) || (start.startsWith(INCLUSIVE_PREFIX) ? p.toString().compareTo(start.substring(1)) >= 0 : p.toString().compareTo(start.substring(1)) > 0);
    }

    protected Predicate<Slice> buildEndPredicate(String end) {
        return p -> this.getEndUnbounded().equals(end) || (end.startsWith(INCLUSIVE_PREFIX) ? p.toString().compareTo(end.substring(1)) <= 0 : p.toString().compareTo(end.substring(1)) < 0);
    }

    protected String getStartUnbounded() {
        return NEGATIVELY_INFINITE;
    }

    protected String getEndUnbounded() {
        return POSITIVELY_INFINITE;
    }
}

