/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.server;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.commands.RedisCommand;
import com.github.fppt.jedismock.commands.RedisCommandParser;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.ParseErrorException;
import com.github.fppt.jedismock.server.RedisOperationExecutor;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.ServiceOptions;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClient
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClient.class);
    private final AtomicBoolean running;
    private final RedisOperationExecutor executor;
    private final Socket socket;
    private final ServiceOptions options;
    private final InputStream in;
    private final OutputStream out;

    RedisClient(Map<Integer, RedisBase> redisBases, Socket socket, ServiceOptions options) throws IOException {
        Objects.requireNonNull(redisBases);
        Objects.requireNonNull(socket);
        Objects.requireNonNull(options);
        OperationExecutorState state = new OperationExecutorState(this, redisBases);
        this.executor = new RedisOperationExecutor(state);
        this.socket = socket;
        this.options = options;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.running = new AtomicBoolean(true);
    }

    @Override
    public void run() {
        while (this.running.get() && !this.socket.isClosed()) {
            Optional<RedisCommand> command = this.nextCommand();
            if (!command.isPresent()) continue;
            Slice response = this.executor.execCommand(command.get());
            this.sendResponse(response, command.toString());
        }
        LOG.debug("Mock redis connection shut down.");
    }

    private Optional<RedisCommand> nextCommand() {
        try {
            return Optional.of(RedisCommandParser.parse(this.in));
        }
        catch (ParseErrorException e) {
            return Optional.empty();
        }
    }

    public void sendResponse(Slice response, String respondingTo) {
        try {
            if (!response.equals(Response.SKIP)) {
                this.out.write(response.data());
            }
        }
        catch (IOException e) {
            LOG.error("unable to send [" + response + "] as response to [" + respondingTo + "]", (Throwable)e);
        }
    }

    public void close() {
        this.running.set(false);
        Utils.closeQuietly(this.socket);
        Utils.closeQuietly(this.in);
        Utils.closeQuietly(this.out);
    }

    ServiceOptions options() {
        return this.options;
    }
}

