/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMHMap;
import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.RMSortedSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.server.RedisClient;
import com.github.fppt.jedismock.storage.ExpiringKeyValueStorage;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RedisBase {
    private final Map<Slice, Set<RedisClient>> subscribers = new HashMap<Slice, Set<RedisClient>>();
    private final Map<Slice, Set<RedisClient>> psubscribers = new HashMap<Slice, Set<RedisClient>>();
    private final Map<Slice, Set<OperationExecutorState>> watchedKeys = new HashMap<Slice, Set<OperationExecutorState>>();
    private final ExpiringKeyValueStorage keyValueStorage = new ExpiringKeyValueStorage(key -> this.watchedKeys.getOrDefault(key, Collections.emptySet()).forEach(OperationExecutorState::watchedKeyIsAffected));

    public Set<Slice> keys() {
        Set<Slice> slices = this.keyValueStorage.values().keySet();
        HashSet<Slice> result = new HashSet<Slice>();
        for (Slice key : slices) {
            Long deadline = this.keyValueStorage.ttls().get(key);
            if (deadline != null && deadline != -1L && deadline <= System.currentTimeMillis()) {
                this.keyValueStorage.delete(key);
                continue;
            }
            result.add(key);
        }
        return result;
    }

    public RMDataStructure getValue(Slice key) {
        return this.keyValueStorage.getValue(key);
    }

    public RMSet getSet(Slice key) {
        RMDataStructure value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof RMSet)) {
            value.raiseTypeCastException();
        }
        return (RMSet)value;
    }

    public RMHMap getMap(Slice key) {
        RMDataStructure value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof RMHMap)) {
            value.raiseTypeCastException();
        }
        return (RMHMap)value;
    }

    public RMList getList(Slice key) {
        RMDataStructure value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof RMList)) {
            value.raiseTypeCastException();
        }
        return (RMList)value;
    }

    public Slice getSlice(Slice key) {
        RMDataStructure value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Slice)) {
            value.raiseTypeCastException();
        }
        return (Slice)value;
    }

    public Slice getSlice(Slice key1, Slice key2) {
        RMSortedSet value = this.getSortedSet(key1);
        if (value == null) {
            return null;
        }
        Map<Slice, Slice> innerMap = value.getStoredData();
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(key2);
    }

    private RMSortedSet getSortedSet(Slice key) {
        RMDataStructure value = this.getValue(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof RMSortedSet)) {
            value.raiseTypeCastException();
        }
        return (RMSortedSet)value;
    }

    public Map<Slice, Slice> getFieldsAndValues(Slice hash) {
        RMSortedSet sortedSet = this.getSortedSet(hash);
        if (sortedSet == null) {
            return null;
        }
        return sortedSet.getStoredData();
    }

    public Long getTTL(Slice key) {
        return this.keyValueStorage.getTTL(key);
    }

    public long setTTL(Slice key, long ttl) {
        return this.keyValueStorage.setTTL(key, ttl);
    }

    public long setDeadline(Slice key, long deadline) {
        return this.keyValueStorage.setDeadline(key, deadline);
    }

    public void clear() {
        this.keyValueStorage.clear();
        this.subscribers.clear();
    }

    public void putSliceWithoutClearingTtl(Slice key, Slice value) {
        this.putSlice(key, value, null);
    }

    public void putSliceWithoutClearingTtl(Slice key1, Slice key2, Slice value) {
        this.putSlice(key1, key2, value, null);
    }

    public void putSlice(Slice key, Slice value) {
        this.putSlice(key, value, -1L);
    }

    public void putSlice(Slice key, Slice value, Long ttl) {
        this.keyValueStorage.put(key, value, ttl);
    }

    public void putSlice(Slice key1, Slice key2, Slice value, Long ttl) {
        this.keyValueStorage.put(key1, key2, value, ttl);
    }

    public void putValue(Slice key, RMDataStructure value, Long ttl) {
        this.keyValueStorage.put(key, value, ttl);
    }

    public void putValue(Slice key, RMDataStructure value) {
        this.keyValueStorage.put(key, value, (Long)-1L);
    }

    public void deleteValue(Slice key) {
        this.keyValueStorage.delete(key);
    }

    public void deleteValue(Slice key1, Slice key2) {
        this.keyValueStorage.delete(key1, key2);
    }

    public void addSubscriber(Slice channel, RedisClient client) {
        HashSet<RedisClient> newClient = new HashSet<RedisClient>();
        newClient.add(client);
        this.subscribers.merge(channel, newClient, (currentSubscribers, newSubscribers) -> {
            currentSubscribers.addAll(newSubscribers);
            return currentSubscribers;
        });
    }

    public void subscribeByPattern(Slice pattern, RedisClient client) {
        HashSet<RedisClient> newClient = new HashSet<RedisClient>();
        newClient.add(client);
        this.psubscribers.merge(pattern, newClient, (currentSubscribers, newSubscribers) -> {
            currentSubscribers.addAll(newSubscribers);
            return currentSubscribers;
        });
    }

    public boolean removeSubscriber(Slice channel, RedisClient client) {
        return this.removeSubscriber(channel, client, this.subscribers);
    }

    public boolean removePSubscriber(Slice channel, RedisClient client) {
        return this.removeSubscriber(channel, client, this.psubscribers);
    }

    private boolean removeSubscriber(Slice channel, RedisClient client, Map<Slice, Set<RedisClient>> subscribers) {
        if (subscribers.containsKey(channel)) {
            Set<RedisClient> redisClients = subscribers.get(channel);
            redisClients.remove(client);
            if (redisClients.isEmpty()) {
                subscribers.remove(channel);
            }
            return true;
        }
        return false;
    }

    public Set<RedisClient> getSubscribers(Slice channel) {
        HashSet<RedisClient> subs = new HashSet<RedisClient>(Collections.emptySet());
        if (this.subscribers.containsKey(channel)) {
            subs.addAll((Collection<RedisClient>)this.subscribers.get(channel));
        }
        return subs;
    }

    public Map<Slice, Set<RedisClient>> getPsubscribers(Slice channel) {
        HashMap<Slice, Set<RedisClient>> matchingPatterns = new HashMap<Slice, Set<RedisClient>>();
        String channelStr = channel.toString();
        for (Map.Entry<Slice, Set<RedisClient>> patternSubscribedClients : this.psubscribers.entrySet()) {
            Slice jedisPattern = patternSubscribedClients.getKey();
            String regexpPattern = RedisBase.getRegexpFromPattern(jedisPattern);
            if (!channelStr.matches(regexpPattern)) continue;
            matchingPatterns.put(jedisPattern, patternSubscribedClients.getValue());
        }
        return matchingPatterns;
    }

    private static String getRegexpFromPattern(Slice pattern) {
        String patternStr = pattern.toString();
        if (patternStr.isEmpty()) {
            return ".*";
        }
        return Utils.createRegexFromGlob(patternStr);
    }

    public int getNumpat() {
        return this.psubscribers.size();
    }

    public Set<Slice> getChannels() {
        return this.subscribers.keySet();
    }

    public List<Slice> getSubscriptions(RedisClient client) {
        ArrayList<Slice> subscriptions = new ArrayList<Slice>();
        this.subscribers.forEach((channel, subscribers) -> {
            if (subscribers.contains(client)) {
                subscriptions.add((Slice)channel);
            }
        });
        return subscriptions;
    }

    public List<Slice> getPSubscriptions(RedisClient client) {
        ArrayList<Slice> subscriptions = new ArrayList<Slice>();
        this.psubscribers.forEach((channel, subscribers) -> {
            if (subscribers.contains(client)) {
                subscriptions.add((Slice)channel);
            }
        });
        return subscriptions;
    }

    public boolean exists(Slice slice) {
        return this.keyValueStorage.exists(slice);
    }

    public Slice type(Slice slice) {
        return this.keyValueStorage.type(slice);
    }

    public void watch(OperationExecutorState state, Slice key) {
        this.watchedKeys.computeIfAbsent(key, k -> new HashSet()).add(state);
    }

    public void unwatchSingleKey(OperationExecutorState state, Slice key) {
        Set<OperationExecutorState> states = this.watchedKeys.get(key);
        if (states != null) {
            states.remove(state);
            if (states.isEmpty()) {
                this.watchedKeys.remove(key);
            }
        }
    }
}

