/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.datastructures.RMHMap;
import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.storage.RedisBase;
import java.io.IOException;
import java.util.List;

public abstract class AbstractRedisOperation
implements RedisOperation {
    private final RedisBase base;
    private final List<Slice> params;

    public AbstractRedisOperation(RedisBase base, List<Slice> params) {
        this.base = base;
        this.params = params;
    }

    protected void doOptionalWork() {
    }

    protected abstract Slice response() throws IOException;

    protected RedisBase base() {
        return this.base;
    }

    protected final List<Slice> params() {
        return this.params;
    }

    public RMList getListFromBaseOrCreateEmpty(Slice key) {
        RMList data = this.base().getList(key);
        if (data == null) {
            return new RMList();
        }
        return data;
    }

    public RMSet getSetFromBaseOrCreateEmpty(Slice key) {
        RMSet data = this.base().getSet(key);
        if (data == null) {
            return new RMSet();
        }
        return data;
    }

    public RMHMap getHMapFromBaseOrCreateEmpty(Slice key) {
        RMHMap data = this.base().getMap(key);
        if (data == null) {
            return new RMHMap();
        }
        return data;
    }

    @Override
    public Slice execute() {
        try {
            this.doOptionalWork();
            return this.response();
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid number of arguments when executing command [" + this.getClass().getSimpleName() + "]", e);
        }
    }
}

