/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.hashes;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="hincrby")
class HIncrBy
extends AbstractRedisOperation {
    HIncrBy(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    Slice hsetValue(Slice key1, Slice key2, Slice value) {
        long numericValue = Utils.convertToLong(String.valueOf(value));
        Slice foundValue = this.base().getSlice(key1, key2);
        if (foundValue != null) {
            numericValue = Utils.convertToLong(new String(foundValue.data())) + numericValue;
        }
        this.base().putSlice(key1, key2, Slice.create(String.valueOf(numericValue)), -1L);
        return Response.integer(numericValue);
    }

    @Override
    protected Slice response() {
        Slice key1 = this.params().get(0);
        Slice key2 = this.params().get(1);
        Slice value = this.params().get(2);
        return this.hsetValue(key1, key2, value);
    }
}

