/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMHMap;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@RedisCommand(value="zrangebyscore")
public class ZRangeByScore
extends AbstractByScoreOperation {
    public ZRangeByScore(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMHMap mapDBObj = this.getHMapFromBaseOrCreateEmpty(key);
        Map<Slice, Double> map = mapDBObj.getStoredData();
        if (map == null || map.isEmpty()) {
            return Response.array(Collections.emptyList());
        }
        String start = this.params().get(1).toString();
        String end = this.params().get(2).toString();
        Predicate<Double> filterPredicate = this.getFilterPredicate(start, end);
        Stream<Map.Entry> entryStream = map.entrySet().stream().filter(e -> filterPredicate.test((Double)e.getValue()));
        boolean withScores = false;
        for (int i = 3; i < this.params().size(); ++i) {
            String param = this.params().get(i).toString();
            if ("withscores".equalsIgnoreCase(param)) {
                withScores = true;
                continue;
            }
            if (!"limit".equalsIgnoreCase(param)) continue;
            long offset = Utils.convertToLong(this.params().get(++i).toString());
            long count = Utils.convertToLong(this.params().get(++i).toString());
            entryStream = entryStream.skip(offset).limit(count);
        }
        Stream<Object> result = withScores ? entryStream.flatMap(e -> Stream.of((Slice)e.getKey(), Slice.create(((Double)e.getValue()).toString()))) : entryStream.map(Map.Entry::getKey);
        return Response.array(result.map(Response::bulkString).collect(Collectors.toList()));
    }
}

