/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMHMap;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.Map;

@RedisCommand(value="zscore")
class ZScore
extends AbstractRedisOperation {
    ZScore(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        Slice val = this.params().get(1);
        RMHMap mapDBObj = this.getHMapFromBaseOrCreateEmpty(key);
        Map<Slice, Double> map = mapDBObj.getStoredData();
        if (val == null || val.toString().isEmpty()) {
            return Response.error("Valid parameter must be provided");
        }
        Double score = map.get(Slice.create(val.toString()));
        return score == null ? Response.NULL : Response.bulkString(Slice.create(score.toString()));
    }
}

