/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.cluster;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RedisCommand(value="cluster", transactional=false)
public class Cluster
implements RedisOperation {
    private static final String NODE_ID = "jedismock";
    private final OperationExecutorState state;
    private final List<Slice> params;

    Cluster(OperationExecutorState state, List<Slice> params) {
        this.state = state;
        this.params = params;
    }

    @Override
    public Slice execute() {
        if (this.params.isEmpty()) {
            return Response.error("ERR Wrong number of arguments for 'cluster' command");
        }
        if (!this.state.owner().options().isClusterModeEnabled()) {
            return Response.error("ERR This instance has cluster support disabled");
        }
        String subcommand = this.params.get(0).toString();
        if ("slots".equalsIgnoreCase(subcommand)) {
            return Response.array(Collections.singletonList(Response.array(Arrays.asList(Response.integer(0L), Response.integer(16383L), Response.array(Arrays.asList(Response.bulkString(Slice.create(this.state.getHost())), Response.integer(this.state.getPort()), Response.bulkString(Slice.create(NODE_ID)), Response.EMPTY_ARRAY))))));
        }
        if ("nodes".equalsIgnoreCase(subcommand)) {
            return Response.bulkString(Slice.create(String.format("%s %s:%d@%d myself,master - 0 1691313236000 1 connected 0-16383", NODE_ID, this.state.getHost(), this.state.getPort(), this.state.getPort() + 10000)));
        }
        if ("myid".equalsIgnoreCase(subcommand)) {
            return Response.bulkString(Slice.create(NODE_ID));
        }
        throw new IllegalArgumentException(String.format("cluster %s subcommand not supported", this.params.get(0)));
    }
}

