/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.scripting;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.scripting.Eval;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.security.NoSuchAlgorithmException;
import java.util.List;

@RedisCommand(value="evalsha")
public class EvalSha
extends AbstractRedisOperation {
    private static final String SCRIPT_PARAM_ERROR = "Wrong number of arguments for EVALSHA";
    private final OperationExecutorState state;

    public EvalSha(RedisBase base, List<Slice> params, OperationExecutorState state) {
        super(base, params);
        this.state = state;
    }

    @Override
    protected Slice response() {
        if (this.params().size() < 2) {
            return Response.error(SCRIPT_PARAM_ERROR);
        }
        String sha = this.params().get(0).toString();
        String script = this.base().getCachedLuaScript(sha);
        if (script == null) {
            return Response.error("NOSCRIPT No matching script. Please use EVAL.");
        }
        this.params().set(0, Slice.create(script));
        try {
            return new Eval(this.base(), this.params(), this.state).response();
        }
        catch (NoSuchAlgorithmException e) {
            return Response.error(e.getMessage());
        }
    }
}

