/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.datastructures.ZSetEntryBound;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.NavigableSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@RedisCommand(value="zrangebylex")
class ZRangeByLex
extends AbstractRedisOperation {
    static final String NEGATIVELY_INFINITE = "-";
    static final String POSITIVELY_INFINITE = "+";
    static final String INCLUSIVE_PREFIX = "[";
    static final String EXCLUSIVE_PREFIX = "(";

    ZRangeByLex(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        String start = this.min();
        if (!this.validateStart(start)) {
            return this.buildErrorResponse("start");
        }
        String end = this.max();
        if (!this.validateEnd(end)) {
            return this.buildErrorResponse("end");
        }
        if (mapDBObj.isEmpty()) {
            return Response.EMPTY_ARRAY;
        }
        double score = ((ZSetEntry)mapDBObj.entries(false).first()).getScore();
        return Response.array(this.doProcess(mapDBObj, start, end, score));
    }

    private Slice buildErrorResponse(String param) {
        return Response.error("Valid " + param + " must start with '" + INCLUSIVE_PREFIX + "' or '" + EXCLUSIVE_PREFIX + "' or unbounded");
    }

    protected boolean validateStart(String start) {
        return NEGATIVELY_INFINITE.equals(start) || this.startsWithAnyPrefix(start);
    }

    protected boolean validateEnd(String end) {
        return POSITIVELY_INFINITE.equals(end) || this.startsWithAnyPrefix(end);
    }

    protected boolean startsWithAnyPrefix(String s) {
        return s.startsWith(INCLUSIVE_PREFIX) || s.startsWith(EXCLUSIVE_PREFIX);
    }

    List<Slice> process(RMZSet map, String start, String end, double score, boolean reverse) {
        NavigableSet<ZSetEntry> subset = map.subset(this.buildStartEntryBound(score, start), this.buildEndEntryBound(score, end));
        if (reverse) {
            subset = subset.descendingSet();
        }
        Stream<Slice> entries = subset.stream().map(ZSetEntry::getValue).map(Response::bulkString);
        for (int i = 3; i < this.params().size(); ++i) {
            String param = this.params().get(i).toString();
            if (!"limit".equalsIgnoreCase(param)) continue;
            long offset = Utils.convertToLong(this.params().get(++i).toString());
            long count = Utils.convertToLong(this.params().get(++i).toString());
            entries = entries.skip(offset);
            if (count < 0L) continue;
            entries = entries.limit(count);
        }
        return entries.collect(Collectors.toList());
    }

    protected List<Slice> doProcess(RMZSet map, String start, String end, double score) {
        return this.process(map, start, end, score, false);
    }

    protected ZSetEntryBound buildStartEntryBound(double score, String start) {
        if (NEGATIVELY_INFINITE.equals(start)) {
            return new ZSetEntryBound(score, ZSetEntry.MIN_VALUE, true);
        }
        return new ZSetEntryBound(score, Slice.create(start.substring(1)), start.startsWith(INCLUSIVE_PREFIX));
    }

    protected ZSetEntryBound buildEndEntryBound(double score, String end) {
        if (POSITIVELY_INFINITE.equals(end)) {
            return new ZSetEntryBound(score, ZSetEntry.MAX_VALUE, false);
        }
        return new ZSetEntryBound(score, Slice.create(end.substring(1)), end.startsWith(INCLUSIVE_PREFIX));
    }

    protected String min() {
        return this.params().get(1).toString();
    }

    protected String max() {
        return this.params().get(2).toString();
    }
}

