/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMHMap;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RedisCommand(value="zadd")
class ZAdd
extends AbstractRedisOperation {
    ZAdd(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMHMap mapDBObj = this.getHMapFromBaseOrCreateEmpty(key);
        Map<Slice, Double> map = mapDBObj.getStoredData();
        int count = 0;
        for (int i = 1; i < this.params().size(); i += 2) {
            double s;
            Slice score = this.params().get(i);
            Slice value = this.params().get(i + 1);
            Double prevScore = map.put(value, s = Utils.convertToDouble(score.toString()));
            if (prevScore != null) continue;
            ++count;
        }
        Map sortedMap = map.entrySet().stream().map(x -> new AbstractMap.SimpleEntry(x.getKey(), Utils.convertToDouble(((Double)x.getValue()).toString()))).sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        try {
            this.base().putValue(key, new RMHMap(sortedMap));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return Response.integer(count);
    }
}

