/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMHMap;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.operations.sortedsets.ZRangeByLex;
import com.github.fppt.jedismock.operations.sortedsets.ZRangeByScore;
import com.github.fppt.jedismock.operations.sortedsets.ZRevRangeByLex;
import com.github.fppt.jedismock.operations.sortedsets.ZRevRangeByScore;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@RedisCommand(value="zrange")
class ZRange
extends AbstractByScoreOperation {
    public static final Comparator<Map.Entry<Slice, Double>> zRangeComparator = Comparator.comparingDouble(Map.Entry::getValue).thenComparing(Map.Entry::getKey);
    private static final String WITH_SCORES = "WITHSCORES";
    private static final String IS_REV = "REV";
    private static final String IS_BYSCORE = "BYSCORE";
    private static final String IS_BYLEX = "BYLEX";
    private boolean withScores = false;
    private boolean isRev = false;
    private boolean isByScore = false;
    private boolean isByLex = false;
    private int start = 0;
    private int end = 0;

    ZRange(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMHMap mapDBObj = this.getHMapFromBaseOrCreateEmpty(key);
        Map<Slice, Double> map = mapDBObj.getStoredData();
        this.parseArgs();
        if (this.isByScore && !this.isRev) {
            ZRangeByScore zRangeByScore = new ZRangeByScore(this.base(), this.params());
            return zRangeByScore.response();
        }
        if (this.isByScore) {
            ZRevRangeByScore zRevRangeByScore = new ZRevRangeByScore(this.base(), this.params());
            return zRevRangeByScore.response();
        }
        if (this.isByLex && !this.isRev) {
            ZRangeByLex zRangeByLex = new ZRangeByLex(this.base(), this.params());
            return zRangeByLex.response();
        }
        if (this.isByLex) {
            ZRevRangeByLex zRevRangeByLex = new ZRevRangeByLex(this.base(), this.params());
            return zRevRangeByLex.response();
        }
        this.calculateIndexes(map);
        boolean finalWithScores = this.withScores;
        List<Slice> values = map.entrySet().stream().sorted(this.isRev ? zRangeComparator.reversed() : zRangeComparator).skip(this.start).limit(this.end - this.start + 1).flatMap(e -> finalWithScores ? Stream.of((Slice)e.getKey(), Slice.create(((Double)e.getValue()).toString())) : Stream.of(e.getKey())).map(Response::bulkString).collect(Collectors.toList());
        return Response.array(values);
    }

    private void calculateIndexes(Map<Slice, Double> map) {
        this.start = Utils.convertToInteger(this.params().get(1).toString());
        this.end = Utils.convertToInteger(this.params().get(2).toString());
        if (this.start < 0) {
            this.start = map.size() + this.start;
            if (this.start < 0) {
                this.start = 0;
            }
        }
        if (this.end < 0) {
            this.end = map.size() + this.end;
            if (this.end < 0) {
                this.end = -1;
            }
        }
        if (this.end >= map.size()) {
            this.end = map.size() - 1;
        }
    }

    private void parseArgs() {
        for (Slice param : this.params()) {
            if (WITH_SCORES.equalsIgnoreCase(param.toString())) {
                this.withScores = true;
            }
            if (IS_REV.equalsIgnoreCase(param.toString())) {
                this.isRev = true;
            }
            if (IS_BYSCORE.equalsIgnoreCase(param.toString())) {
                this.isByScore = true;
            }
            if (!IS_BYLEX.equalsIgnoreCase(param.toString())) continue;
            this.isByLex = true;
        }
    }
}

