/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.strings;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="append")
class Append
extends AbstractRedisOperation {
    Append(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        int i;
        Slice key = this.params().get(0);
        Slice value = this.params().get(1);
        Slice s = this.base().getSlice(key);
        if (s == null) {
            this.base().putSlice(key, value);
            return Response.integer(value.length());
        }
        byte[] b = new byte[s.length() + value.length()];
        for (i = 0; i < s.length(); ++i) {
            b[i] = s.data()[i];
        }
        for (i = s.length(); i < s.length() + value.length(); ++i) {
            b[i] = value.data()[i - s.length()];
        }
        this.base().putSlice(key, Slice.create(b));
        return Response.integer(b.length);
    }
}

