/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.lists.LRange;
import com.github.fppt.jedismock.operations.lists.RPopLPush;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.SliceParser;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.Arrays;
import java.util.List;

@RedisCommand(value="brpoplpush")
class BRPopLPush
extends RPopLPush {
    private long count = 0L;
    private final Object lock;

    BRPopLPush(OperationExecutorState state, List<Slice> params) {
        super(state, params);
        this.lock = state.lock();
    }

    @Override
    protected void doOptionalWork() {
        Slice source = this.params().get(0);
        long timeout = Utils.convertToLong(this.params().get(2).toString());
        long waitEnd = System.nanoTime() + timeout * 1000000000L;
        this.count = this.getCount(source);
        try {
            long waitTime;
            while (this.count == 0L && (waitTime = (waitEnd - System.nanoTime()) / 1000000L) > 0L) {
                this.lock.wait(waitTime);
                this.count = this.getCount(source);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected Slice response() {
        if (this.count != 0L) {
            return super.response();
        }
        return Response.NULL;
    }

    private long getCount(Slice source) {
        Slice index = Slice.create("0");
        List<Slice> commands = Arrays.asList(source, index, index);
        Slice result = new LRange(this.base(), commands).execute();
        return SliceParser.consumeCount(result.data());
    }
}

