/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;

@RedisCommand(value="lrange")
class LRange
extends AbstractRedisOperation {
    LRange(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMList listDBObj = this.getListFromBaseOrCreateEmpty(key);
        List<Slice> list = listDBObj.getStoredData();
        int start = Utils.convertToInteger(this.params().get(1).toString());
        int end = Utils.convertToInteger(this.params().get(2).toString());
        if (start < 0 && (start = list.size() + start) < 0) {
            start = 0;
        }
        if (end < 0 && (end = list.size() + end) < 0) {
            end = 0;
        }
        ArrayList<Slice> result = new ArrayList<Slice>();
        for (int i = start; i <= end && i < list.size(); ++i) {
            result.add(Response.bulkString(list.get(i)));
        }
        return Response.array(result);
    }
}

