/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.server;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.CommandFactory;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.RedisOperationExecutor;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RedisOperationExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Slice proceed(OperationExecutorState state, String name, List<Slice> commandParams) {
        Object object = state.lock();
        synchronized (object) {
            try {
                RedisOperation operation = CommandFactory.buildOperation(name, false, state, commandParams);
                if (operation != null) {
                    return operation.execute();
                }
                operation = CommandFactory.buildOperation(name, true, state, commandParams);
                if (operation != null) {
                    if (!state.isTransactionModeOn()) {
                        return Response.clientResponse(name, operation.execute());
                    }
                    state.tx().add(operation);
                    return Response.clientResponse(name, Response.OK);
                }
                return Response.error(String.format("Unsupported operation: %s", name));
            }
            catch (Exception e) {
                LOG.error("Malformed request", (Throwable)e);
                return Response.error(e.getMessage());
            }
        }
    }

    public static Slice breakConnection(OperationExecutorState state) {
        state.owner().close();
        return Response.SKIP;
    }
}

