/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@RedisCommand(value="spop")
class SPop
extends AbstractRedisOperation {
    SPop(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    private List<Slice> popper(Set<Slice> collection, int number) {
        ArrayList<Slice> result = new ArrayList<Slice>();
        Iterator<Slice> it = collection.iterator();
        while (number > 0 && it.hasNext()) {
            Slice v = it.next();
            result.add(Response.bulkString(v));
            it.remove();
            --number;
        }
        return result;
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        int number = this.params().size() > 1 ? Utils.convertToInteger(this.params().get(1).toString()) : 1;
        RMSet setDBObj = this.getSetFromBaseOrCreateEmpty(key);
        Set<Slice> data = setDBObj.getStoredData();
        if (data == null || data.isEmpty()) {
            return Response.NULL;
        }
        List<Slice> v = this.popper(data, number);
        if (v.size() == 1) {
            return v.get(0);
        }
        return Response.array(v);
    }
}

