/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

@RedisCommand(value="srandmember")
public class SRandMember
extends AbstractRedisOperation {
    public SRandMember(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMSet set = this.base().getSet(key);
        if (set == null) {
            return Response.NULL;
        }
        int number = this.params().size() > 1 ? Utils.convertToInteger(this.params().get(1).toString()) : 1;
        ArrayList<Slice> list = new ArrayList<Slice>(set.getStoredData());
        if (number == 1) {
            int index = ThreadLocalRandom.current().nextInt(list.size());
            return Response.bulkString((Slice)list.get(index));
        }
        if (number > 1) {
            Collections.shuffle(list);
            return Response.array(list.stream().map(Response::bulkString).limit(number).collect(Collectors.toList()));
        }
        List<Slice> result = ThreadLocalRandom.current().ints(-number, 0, list.size()).mapToObj(list::get).map(Response::bulkString).collect(Collectors.toList());
        return Response.array(result);
    }
}

