/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;

@RedisCommand(value="zremrangebyscore")
public class ZRemRangeByScore
extends AbstractByScoreOperation {
    ZRemRangeByScore(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        if (mapDBObj.isEmpty()) {
            return Response.integer(0L);
        }
        String start = this.params().get(1).toString();
        String end = this.params().get(2).toString();
        ArrayList<ZSetEntry> subset = new ArrayList<ZSetEntry>(mapDBObj.subset(this.getStartBound(start), this.getEndBound(end)));
        for (ZSetEntry entry : subset) {
            mapDBObj.remove(entry.getValue());
        }
        if (mapDBObj.isEmpty()) {
            this.base().deleteValue(key);
        } else {
            this.base().putValue(key, mapDBObj);
        }
        return Response.integer(subset.size());
    }
}

