/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures.streams;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StreamId
implements Comparable<StreamId> {
    private final long firstPart;
    private final long secondPart;

    public long getFirstPart() {
        return this.firstPart;
    }

    public long getSecondPart() {
        return this.secondPart;
    }

    StreamId() {
        this(0L, 0L);
    }

    public StreamId(long firstPart, long secondPart) {
        this.firstPart = firstPart;
        this.secondPart = secondPart;
    }

    public StreamId(String key) throws WrongStreamKeyException {
        Matcher matcher = Pattern.compile("(\\d+)(?:-(\\d+))?").matcher(key);
        if (matcher.matches()) {
            try {
                this.firstPart = Long.parseUnsignedLong(matcher.group(1));
                this.secondPart = matcher.group(2) == null ? 0L : Long.parseUnsignedLong(matcher.group(2));
            }
            catch (NumberFormatException e) {
                throw new WrongStreamKeyException("ERR Invalid stream ID specified as stream command argument");
            }
        } else {
            throw new WrongStreamKeyException("ERR Invalid stream ID specified as stream command argument");
        }
    }

    public StreamId(Slice slice) throws WrongStreamKeyException {
        this(slice.toString());
    }

    public boolean isZero() {
        return this.secondPart == 0L && this.firstPart == 0L;
    }

    public StreamId increment() throws WrongStreamKeyException {
        long second = this.secondPart + 1L;
        long first = this.firstPart;
        if (Long.compareUnsigned(second, 0L) == 0) {
            if (Long.compareUnsigned(first, -1L) == 0) {
                throw new WrongStreamKeyException("ERR invalid start ID for the interval");
            }
            ++first;
        }
        return new StreamId(first, second);
    }

    public StreamId decrement() throws WrongStreamKeyException {
        long second = this.secondPart - 1L;
        long first = this.firstPart;
        if (Long.compareUnsigned(second, -1L) == 0) {
            if (Long.compareUnsigned(first, 0L) == 0) {
                throw new WrongStreamKeyException("ERR invalid end ID for the interval");
            }
            --first;
        }
        return new StreamId(first, second);
    }

    @Override
    public int compareTo(StreamId other) {
        int firstPartComparison = Long.compareUnsigned(this.firstPart, other.firstPart);
        return firstPartComparison != 0 ? firstPartComparison : Long.compareUnsigned(this.secondPart, other.secondPart);
    }

    public Slice toSlice() {
        return Slice.create(this.toString());
    }

    public String toString() {
        return Long.toUnsignedString(this.firstPart) + "-" + Long.toUnsignedString(this.secondPart);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamId)) {
            return false;
        }
        StreamId streamId = (StreamId)o;
        if (this.firstPart != streamId.firstPart) {
            return false;
        }
        return this.secondPart == streamId.secondPart;
    }

    public int hashCode() {
        return Objects.hash(this.firstPart, this.secondPart);
    }
}

