/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class ZStore
extends AbstractByScoreOperation {
    private final Object lock;
    protected static final String IS_WEIGHTS = "WEIGHTS";
    protected static final String IS_AGGREGATE = "AGGREGATE";
    protected static final String IS_WITHSCORES = "WITHSCORES";
    protected static final String IS_LIMIT = "LIMIT";
    protected boolean isLimit = false;
    protected long limit = 0L;
    protected int startKeysIndex = 0;
    protected ArrayList<Double> weights;
    protected BiFunction<Double, Double, Double> aggregate = ZStore.getSum();
    protected boolean withScores = false;

    ZStore(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    protected abstract RMZSet getResult(RMZSet var1, RMZSet var2, double var3);

    protected RMZSet getFinishedZSet() {
        int numKeys = Integer.parseInt(this.params().get(this.startKeysIndex).toString());
        if (numKeys == 0) {
            throw new ArgumentException("*at least 1 input key * '" + this.getClass().getSimpleName().toLowerCase() + "' command");
        }
        this.parseParams(numKeys);
        if (this.params().size() != numKeys + this.startKeysIndex + 1) {
            throw new ArgumentException("ERR syntax error*");
        }
        RMZSet mapDBObj = new RMZSet();
        RMZSet temp = this.getZSet(this.params().get(this.startKeysIndex + 1));
        for (ZSetEntry entry : temp.entries(false)) {
            mapDBObj.put(entry.getValue(), ZStore.getMultiple(entry.getScore(), this.weights.get(0)));
        }
        for (int i = 1; i < numKeys; ++i) {
            mapDBObj = this.getResult(mapDBObj, this.getZSet(this.params().get(this.startKeysIndex + i + 1)), this.weights.get(i));
        }
        return mapDBObj;
    }

    private RMZSet getZSet(Slice setName) {
        if (this.base().exists(setName)) {
            String typeName = this.base().getValue(setName).getTypeName();
            if ("zset".equalsIgnoreCase(typeName)) {
                return this.base().getZSet(setName);
            }
            if ("set".equalsIgnoreCase(typeName)) {
                RMZSet result = new RMZSet();
                for (Slice value : this.base().getSet(setName).getStoredData()) {
                    result.put(value, 1.0);
                }
                return result;
            }
        }
        return new RMZSet();
    }

    private void parseParams(int numKeys) {
        this.weights = new ArrayList(numKeys);
        for (int i = 0; i < numKeys; ++i) {
            this.weights.add(1.0);
        }
        ArrayList<Slice> temp = new ArrayList<Slice>(this.params());
        for (Slice param : temp) {
            if (IS_WEIGHTS.equalsIgnoreCase(param.toString())) {
                int index = this.params().indexOf(param);
                for (int i = 0; i < numKeys; ++i) {
                    double weight;
                    try {
                        weight = ZStore.toDouble(this.params().get(index + 1).toString());
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new ArgumentException("ERR syntax error*");
                    }
                    this.weights.set(i, weight);
                    this.params().remove(index + 1);
                }
                this.params().remove(param);
            }
            if (IS_AGGREGATE.equalsIgnoreCase(param.toString())) {
                String aggParam;
                try {
                    aggParam = this.params().get(this.params().indexOf(param) + 1).toString();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ArgumentException("ERR syntax error*");
                }
                if ("MIN".equalsIgnoreCase(aggParam)) {
                    this.aggregate = Double::min;
                }
                if ("MAX".equalsIgnoreCase(aggParam)) {
                    this.aggregate = Double::max;
                }
                if ("SUM".equalsIgnoreCase(aggParam)) {
                    this.aggregate = ZStore.getSum();
                }
                this.params().remove(this.params().indexOf(param) + 1);
                this.params().remove(param);
            }
            if (IS_WITHSCORES.equalsIgnoreCase(param.toString())) {
                this.withScores = true;
                if (this.getClass().getSimpleName().endsWith("Store")) {
                    throw new ArgumentException("ERR syntax error");
                }
                this.params().remove(param);
            }
            if (!IS_LIMIT.equalsIgnoreCase(param.toString())) continue;
            this.isLimit = true;
            try {
                this.limit = Long.parseLong(this.params().get(this.params().indexOf(param) + 1).toString());
            }
            catch (IndexOutOfBoundsException e) {
                throw new ArgumentException("ERR syntax error*");
            }
            catch (NumberFormatException e) {
                throw new ArgumentException("ERR LIMIT*");
            }
            if (this.limit < 0L) {
                throw new ArgumentException("ERR LIMIT* Negative limit");
            }
            this.params().remove(this.params().indexOf(param) + 1);
            this.params().remove(param);
        }
    }

    private static BiFunction<Double, Double, Double> getSum() {
        return (a, b) -> {
            if (a.isInfinite() && b.isInfinite()) {
                if (a.equals(b)) {
                    return a;
                }
                return 0.0;
            }
            return a + b;
        };
    }

    protected static Double getMultiple(Double score, Double weight) {
        if (score == 0.0 || weight == 0.0) {
            return 0.0;
        }
        return score * weight;
    }

    protected long getResultSize() {
        Slice keyDest = this.params().get(0);
        if (this.base().exists(keyDest)) {
            this.base().deleteValue(keyDest);
        }
        this.startKeysIndex = 1;
        RMZSet mapDBObj = this.getFinishedZSet();
        if (!mapDBObj.isEmpty()) {
            this.base().putValue(keyDest, mapDBObj);
            this.lock.notifyAll();
        }
        return mapDBObj.size();
    }

    protected List<Slice> getResultArray() {
        this.startKeysIndex = 0;
        return this.getFinishedZSet().entries(false).stream().flatMap(e -> this.withScores ? Stream.of(e.getValue(), Slice.create(String.valueOf(Math.round(e.getScore())))) : Stream.of(e.getValue())).map(Response::bulkString).collect(Collectors.toList());
    }
}

