/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.RedisServer;
import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.commands.RedisCommand;
import com.github.fppt.jedismock.commands.RedisCommandParser;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.EOFException;
import com.github.fppt.jedismock.exception.ParseErrorException;
import com.github.fppt.jedismock.server.RedisOperationExecutor;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.ServiceOptions;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.time.Clock;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedisClient
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClient.class);
    private final RedisServer server;
    private final Socket socket;
    private final AtomicBoolean running;
    private final RedisOperationExecutor executor;
    private final InputStream in;
    private final OutputStream out;
    private final Consumer<RedisClient> onClose;

    RedisClient(RedisServer server, Socket socket, Consumer<RedisClient> onClose) throws IOException {
        Objects.requireNonNull(server);
        Objects.requireNonNull(socket);
        Objects.requireNonNull(onClose);
        this.server = server;
        OperationExecutorState state = new OperationExecutorState(this, server.getRedisBases());
        this.executor = new RedisOperationExecutor(state);
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.running = new AtomicBoolean(true);
        this.onClose = onClose;
    }

    @Override
    public void run() {
        while (this.running.get() && !this.socket.isClosed() && !Thread.interrupted()) {
            Optional<RedisCommand> command = this.nextCommand();
            if (!command.isPresent()) continue;
            Slice response = this.executor.execCommand(command.get());
            this.sendResponse(response, command.toString());
        }
        LOG.debug("Mock redis connection shut down.");
    }

    private Optional<RedisCommand> nextCommand() {
        try {
            return Optional.of(RedisCommandParser.parse(this.in));
        }
        catch (ParseErrorException e) {
            return Optional.empty();
        }
        catch (EOFException e) {
            this.close();
            return Optional.empty();
        }
    }

    public void sendResponse(Slice response, String respondingTo) {
        try {
            if (!response.equals(Response.SKIP)) {
                this.out.write(response.data());
            }
        }
        catch (IOException e) {
            LOG.error("unable to send [" + response + "] as response to [" + respondingTo + "]", (Throwable)e);
        }
    }

    public void close() {
        this.running.set(false);
        Utils.closeQuietly(this.socket);
        Utils.closeQuietly(this.in);
        Utils.closeQuietly(this.out);
        this.onClose.accept(this);
    }

    public ServiceOptions options() {
        return this.server.options();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public Clock getClock() {
        return this.server.getClock();
    }

    public String getServerHost() {
        return this.server.getHost();
    }
}

