/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMHash;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.storage.ExpiringStorage;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ExpiringKeyValueStorage
extends ExpiringStorage {
    private final Map<Slice, RMDataStructure> values = new HashMap<Slice, RMDataStructure>();

    public ExpiringKeyValueStorage(Supplier<Clock> clockSupplier, Consumer<Slice> keyChangeNotifier) {
        super(clockSupplier, keyChangeNotifier);
    }

    public Map<Slice, RMDataStructure> values() {
        return this.values;
    }

    @Override
    public void delete(Slice key) {
        this.keyChangeNotifier.accept(key);
        super.delete(key);
        this.values().remove(key);
    }

    @Override
    protected boolean keyExists(Slice key) {
        return this.values.containsKey(key);
    }

    public void delete(Slice key1, Slice key2) {
        this.keyChangeNotifier.accept(key1);
        Objects.requireNonNull(key2);
        if (!this.verifyKey(key1)) {
            return;
        }
        RMHash hashByKey = this.getRMHash(key1);
        if (!hashByKey.keyExists(key2)) {
            return;
        }
        hashByKey.delete(key2);
        if (hashByKey.isEmpty()) {
            this.values.remove(key1);
        }
        if (!this.values().containsKey(key1)) {
            super.delete(key1);
        }
    }

    @Override
    public void clear() {
        for (Slice key : this.values().keySet()) {
            if (this.isKeyOutdated(key)) continue;
            this.keyChangeNotifier.accept(key);
        }
        this.values().clear();
        super.clear();
    }

    public RMDataStructure getValue(Slice key) {
        if (!this.verifyKey(key)) {
            return null;
        }
        return this.values().get(key);
    }

    private boolean verifyKey(Slice key) {
        Objects.requireNonNull(key);
        if (!this.values().containsKey(key)) {
            return false;
        }
        if (this.isKeyOutdated(key)) {
            this.delete(key);
            return false;
        }
        RMDataStructure o = this.values.get(key);
        if (o instanceof RMHash && ((RMHash)o).isLazilyExpired()) {
            this.delete(key);
            return false;
        }
        return true;
    }

    public void put(Slice key, RMDataStructure value, Long ttl) {
        this.keyChangeNotifier.accept(key);
        this.values().put(key, value);
        this.configureTTL(key, ttl);
    }

    public void put(Slice key, Slice value, Long ttl) {
        this.keyChangeNotifier.accept(key);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.values().put(key, value.extract());
        this.configureTTL(key, ttl);
    }

    public void put(Slice key1, Slice key2, Slice value, Long ttl) {
        RMHash mapByKey;
        this.keyChangeNotifier.accept(key1);
        Objects.requireNonNull(key1);
        Objects.requireNonNull(key2);
        Objects.requireNonNull(value);
        if (!this.values.containsKey(key1)) {
            mapByKey = new RMHash(this.getClockSupplier());
            this.values.put(key1, mapByKey);
        } else {
            mapByKey = this.getRMHash(key1);
        }
        mapByKey.put(key2, value);
        this.configureTTL(key1, ttl);
    }

    private RMHash getRMHash(Slice key) {
        RMDataStructure valueByKey = this.values.get(key);
        if (!this.isHashValue(valueByKey)) {
            valueByKey.raiseTypeCastException();
        }
        return (RMHash)valueByKey;
    }

    public boolean exists(Slice slice) {
        return this.verifyKey(slice);
    }

    private boolean isHashValue(RMDataStructure value) {
        return value instanceof RMHash;
    }

    public Slice type(Slice key) {
        if (!this.verifyKey(key)) {
            return Slice.create("none");
        }
        RMDataStructure valueByKey = this.getValue(key);
        if (valueByKey == null) {
            return Slice.create("none");
        }
        return Slice.create(valueByKey.getTypeName());
    }
}

