/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.datastructures.ZSetEntryBound;
import com.github.fppt.jedismock.operations.sortedsets.AbstractZRange;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

abstract class AbstractZRangeByScore
extends AbstractZRange {
    AbstractZRangeByScore(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    public final ZSetEntryBound getStartBound(Slice startSlice) {
        String start = startSlice.toString();
        if ("-inf".equalsIgnoreCase(start)) {
            return ZSetEntryBound.MINUS_INF;
        }
        if (start.startsWith("(")) {
            return new ZSetEntryBound(AbstractZRangeByScore.toDouble(start.substring(1)), ZSetEntry.MAX_VALUE, false);
        }
        return new ZSetEntryBound(AbstractZRangeByScore.toDouble(start), ZSetEntry.MIN_VALUE, true);
    }

    @Override
    public final ZSetEntryBound getEndBound(Slice endSlice) {
        String end = endSlice.toString();
        if ("+inf".equalsIgnoreCase(end)) {
            return new ZSetEntryBound(Double.POSITIVE_INFINITY, ZSetEntry.MAX_VALUE, end.startsWith("("));
        }
        if (end.startsWith("(")) {
            return new ZSetEntryBound(AbstractZRangeByScore.toDouble(end.substring(1)), ZSetEntry.MIN_VALUE, false);
        }
        return new ZSetEntryBound(AbstractZRangeByScore.toDouble(end), ZSetEntry.MAX_VALUE, true);
    }
}

