/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.streams;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.RMStream;
import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.StreamId;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.streams.XTrim;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="xadd")
public class XAdd
extends AbstractRedisOperation {
    public XAdd(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    void validate(StreamId key) throws WrongStreamKeyException {
        if (key.isZero()) {
            throw new WrongStreamKeyException("ERR The ID specified in XADD must be greater than 0-0");
        }
        StreamId lastId = this.getStreamFromBaseOrCreateEmpty(this.params().get(0)).getLastId();
        if (key.compareTo(lastId) <= 0) {
            throw new WrongStreamKeyException("ERR The ID specified in XADD is equal or smaller than the target stream top item");
        }
    }

    @Override
    protected int minArgs() {
        return 4;
    }

    @Override
    protected Slice response() {
        StreamId nodeId;
        Slice key = this.params().get(0);
        RMStream stream = this.getStreamFromBaseOrCreateEmpty(key);
        SequencedMap<StreamId, SequencedMap<Slice, Slice>> map = stream.getStoredData();
        int idInd = 1;
        if ("nomkstream".equalsIgnoreCase(this.params().get(1).toString())) {
            if (!this.base().exists(key)) {
                return Response.NULL;
            }
            ++idInd;
        }
        String criterion = "";
        int thresholdPosition = idInd + 1;
        int limit = map.size() + 1;
        String param = this.params().get(idInd).toString();
        if ("maxlen".equalsIgnoreCase(param) || "minid".equalsIgnoreCase(param)) {
            criterion = this.params().get(idInd++).toString();
            param = this.params().get(idInd++).toString();
            boolean approxTrim = "~".equals(param);
            if ("~".equals(param) || "=".equals(param)) {
                ++thresholdPosition;
                ++idInd;
            }
            if ("limit".equalsIgnoreCase(this.params().get(idInd).toString())) {
                try {
                    limit = Integer.parseInt(this.params().get(++idInd).toString());
                }
                catch (NumberFormatException e) {
                    return Response.error("ERR value is not an integer or out of range");
                }
                if (!approxTrim) {
                    return Response.error("ERR syntax error, LIMIT cannot be used without the special ~ option");
                }
            }
        }
        int n = ++idInd;
        ++idInd;
        Slice id = this.params().get(n);
        try {
            nodeId = new StreamId(stream.replaceAsterisk(id));
            this.validate(nodeId);
        }
        catch (WrongStreamKeyException e) {
            return Response.error(e.getMessage());
        }
        SequencedMap<Slice, Slice> entryValues = new SequencedMap<Slice, Slice>();
        for (int i = idInd; i < this.params().size(); i += 2) {
            entryValues.append(this.params().get(i), this.params().get(i + 1));
        }
        map.append(nodeId, entryValues);
        stream.updateLastId(nodeId);
        this.base().putValue(key, stream);
        switch (criterion.toUpperCase()) {
            case "MAXLEN": {
                try {
                    int threshold = Integer.parseInt(this.params().get(thresholdPosition).toString());
                    XTrim.trimLen(map, threshold, limit);
                    break;
                }
                catch (NumberFormatException e) {
                    return Response.error("ERR syntax error");
                }
            }
            case "MINID": {
                try {
                    StreamId threshold = new StreamId(this.params().get(thresholdPosition));
                    XTrim.trimID(map, threshold, limit);
                    break;
                }
                catch (WrongStreamKeyException e) {
                    return Response.error(e.getMessage());
                }
            }
        }
        return Response.bulkString(nodeId.toSlice());
    }
}

