/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.streams;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.StreamId;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Iterator;
import java.util.List;

@RedisCommand(value="xtrim")
public class XTrim
extends AbstractRedisOperation {
    public XTrim(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    static int trimLen(SequencedMap<?, ?> map, int threshold, int limit) {
        int numberOfEvictedNodes;
        for (numberOfEvictedNodes = 0; map.size() > threshold && numberOfEvictedNodes < limit; ++numberOfEvictedNodes) {
            map.removeHead();
        }
        return numberOfEvictedNodes;
    }

    static int trimID(SequencedMap<StreamId, ?> map, StreamId threshold, int limit) {
        int numberOfEvictedNodes;
        Iterator it = map.iterator();
        for (numberOfEvictedNodes = 0; it.hasNext() && numberOfEvictedNodes < limit && ((StreamId)it.next().getKey()).compareTo(threshold) < 0; ++numberOfEvictedNodes) {
            it.remove();
        }
        return numberOfEvictedNodes;
    }

    @Override
    protected int minArgs() {
        return 3;
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        SequencedMap<StreamId, SequencedMap<Slice, Slice>> map = this.getStreamFromBaseOrCreateEmpty(key).getStoredData();
        String criterion = this.params().get(1).toString();
        int thresholdPosition = 2;
        String param = this.params().get(2).toString();
        if ("~".equals(param) || "=".equals(param)) {
            ++thresholdPosition;
        }
        boolean aproxTrim = "~".equals(param);
        int limit = map.size() + 1;
        if (this.params().size() > thresholdPosition + 3) {
            return Response.error("ERR syntax error");
        }
        if (this.params().size() > thresholdPosition + 1) {
            if ("limit".equalsIgnoreCase(this.params().get(thresholdPosition + 1).toString())) {
                try {
                    limit = Integer.parseInt(this.params().get(thresholdPosition + 2).toString());
                }
                catch (NumberFormatException e) {
                    return Response.error("ERR value is not an integer or out of range");
                }
                if (!aproxTrim) {
                    return Response.error("ERR syntax error, LIMIT cannot be used without the special ~ option");
                }
            } else {
                return Response.error("ERR syntax error");
            }
        }
        switch (criterion.toUpperCase()) {
            case "MAXLEN": {
                try {
                    int threshold = Integer.parseInt(this.params().get(thresholdPosition).toString());
                    return Response.integer(XTrim.trimLen(map, threshold, limit));
                }
                catch (NumberFormatException e) {
                    return Response.error("ERR syntax error");
                }
            }
            case "MINID": {
                try {
                    StreamId threshold = new StreamId(this.params().get(thresholdPosition));
                    return Response.integer(XTrim.trimID(map, threshold, limit));
                }
                catch (WrongStreamKeyException e) {
                    return Response.error(e.getMessage());
                }
            }
        }
        return Response.error("ERR syntax error");
    }
}

