/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="zscore")
class ZScore
extends AbstractRedisOperation {
    private static final double DELTA = 1.0E-6;

    ZScore(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        Slice val = this.params().get(1);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        Double score = mapDBObj.getScore(val);
        if (score == null) {
            return Response.NULL;
        }
        if (score.isInfinite()) {
            return score > 0.0 ? Response.bulkString(Slice.create("inf")) : Response.bulkString(Slice.create("-inf"));
        }
        long round = Math.round(score);
        if (Math.abs(score - (double)round) < 1.0E-6) {
            return Response.bulkString(Slice.create(String.format("%.0f", score)));
        }
        return Response.bulkString(Slice.create(String.format("%10.16e", score).replace(',', '.')));
    }
}

