/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class VsnetMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    protected InputMap windowInputMap;
    private static final boolean DEBUG = false;
    protected Color shadowColor;
    protected int defaultAccelEndGap;
    protected int defaultShadowWidth;
    protected Color borderColor;
    protected Color backgroundColor;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    protected boolean _isFloatingIcon = false;
    private ThemePainter _painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    protected static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle acceleratorRect = new Rectangle();
    protected static Rectangle checkIconRect = new Rectangle();
    protected static Rectangle arrowIconRect = new Rectangle();
    protected static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new VsnetMenuItemUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIDefaultsLookup.getFont("MenuItem.acceleratorFont");
        if (this.acceleratorFont == null) {
            this.acceleratorFont = UIManager.getFont("MenuItem.font");
        }
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIDefaultsLookup.getInsets(string + ".margin"));
        }
        this.defaultTextIconGap = UIDefaultsLookup.getInt(string + ".textIconGap");
        this.defaultAccelEndGap = UIDefaultsLookup.getInt("MenuItem.accelEndGap");
        this.defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        this.borderColor = UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
        this.backgroundColor = UIDefaultsLookup.getColor("MenuItem.background");
        this.shadowColor = UIDefaultsLookup.getColor("MenuItem.shadowColor");
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        Object object = UIDefaultsLookup.get(string + ".borderPainted");
        if (object instanceof Boolean) {
            this.menuItem.setBorderPainted((Boolean)object);
        }
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIDefaultsLookup.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIDefaultsLookup.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIDefaultsLookup.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIDefaultsLookup.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIDefaultsLookup.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIDefaultsLookup.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIDefaultsLookup.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIDefaultsLookup.getIcon(string + ".checkIcon");
        }
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent jComponent2 = (JComponent)container;
            jComponent2.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent2.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    protected ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        String string2 = string + ".actionMap";
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get(string2);
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(string2, actionMap);
        }
        return actionMap;
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("doClick", new ClickAction());
        return actionMapUIResource;
    }

    protected InputMap createInputMap(int n) {
        if (n == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (keyStroke != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(keyStroke, "doClick");
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Serializable serializable;
        Container container;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n2;
            int n3 = keyStroke.getModifiers();
            if (n3 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n3);
                string2 = string2 + this.acceleratorDelimiter;
            }
            string2 = (n2 = keyStroke.getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n2) : string2 + keyStroke.getKeyChar();
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n, this.defaultTextIconGap);
        if (string != null && string.trim().length() != 0) {
            r.setBounds(textRect);
        }
        if (!iconRect.isEmpty()) {
            r = SwingUtilities.computeUnion(VsnetMenuItemUI.iconRect.x, VsnetMenuItemUI.iconRect.y, VsnetMenuItemUI.iconRect.width, VsnetMenuItemUI.iconRect.height, r);
        }
        if (!((container = this.menuItem.getParent()) == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int n4;
            serializable = (JComponent)container;
            Integer n5 = (Integer)((JComponent)serializable).getClientProperty(MAX_TEXT_WIDTH);
            Integer n6 = (Integer)((JComponent)serializable).getClientProperty(MAX_ACC_WIDTH);
            int n7 = n5 != null ? n5 : 0;
            int n8 = n4 = n6 != null ? n6 : 0;
            if (VsnetMenuItemUI.r.width < n7) {
                VsnetMenuItemUI.r.width = n7;
            } else {
                ((JComponent)serializable).putClientProperty(MAX_TEXT_WIDTH, VsnetMenuItemUI.r.width);
            }
            if (VsnetMenuItemUI.acceleratorRect.width > n4) {
                n4 = VsnetMenuItemUI.acceleratorRect.width;
                ((JComponent)serializable).putClientProperty(MAX_ACC_WIDTH, VsnetMenuItemUI.acceleratorRect.width);
            }
            VsnetMenuItemUI.r.width += n4;
            VsnetMenuItemUI.r.width += n;
            VsnetMenuItemUI.r.width += this.defaultAccelEndGap;
        }
        if (string != null && string.trim().length() != 0 && icon3 != null) {
            VsnetMenuItemUI.r.width += n;
        }
        serializable = jMenuItem.getInsets();
        if (this.useCheckAndArrow()) {
            ((Insets)serializable).left = 0;
            ((Insets)serializable).right = 0;
            VsnetMenuItemUI.r.width += 5;
        }
        if (this.isDownArrowVisible(container)) {
            ((Insets)serializable).left = 0;
            ((Insets)serializable).right = 0;
            VsnetMenuItemUI.r.width += 7;
        }
        if (serializable != null) {
            VsnetMenuItemUI.r.width += ((Insets)serializable).left + ((Insets)serializable).right;
            VsnetMenuItemUI.r.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (VsnetMenuItemUI.r.width % 2 == 0) {
            ++VsnetMenuItemUI.r.width;
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            return r.getSize();
        }
        return new Dimension(VsnetMenuItemUI.r.height, VsnetMenuItemUI.r.width);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Object object;
        int n2;
        int n3;
        Serializable serializable2;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        Object object2 = jMenuItem.getClientProperty("MenuItem.shadowWidth");
        if (object2 instanceof Number) {
            this.defaultShadowWidth = ((Number)object2).intValue();
            if (jMenuItem instanceof JMenu) {
                for (Serializable serializable2 : ((JMenu)jMenuItem).getMenuComponents()) {
                    if (!(serializable2 instanceof JMenuItem) || ((JMenuItem)serializable2).getClientProperty("MenuItem.shadowWidth") != null) continue;
                    ((JMenuItem)serializable2).putClientProperty("MenuItem.shadowWidth", this.defaultShadowWidth);
                }
            }
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            n3 = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n3 = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -n2 + 1);
        }
        Insets insets = jComponent.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n3, n2);
        if (this.isDownArrowVisible(jMenuItem.getParent())) {
            VsnetMenuItemUI.viewRect.x += 3;
            VsnetMenuItemUI.viewRect.width -= 7;
        } else {
            VsnetMenuItemUI.viewRect.x += insets.left;
            VsnetMenuItemUI.viewRect.width -= insets.right + VsnetMenuItemUI.viewRect.x;
        }
        VsnetMenuItemUI.viewRect.y += insets.top;
        VsnetMenuItemUI.viewRect.height -= insets.bottom + VsnetMenuItemUI.viewRect.y;
        serializable2 = graphics.getFont();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n4;
            int n5 = keyStroke.getModifiers();
            if (n5 > 0) {
                string = KeyEvent.getKeyModifiersText(n5);
                string = string + this.acceleratorDelimiter;
            }
            string = (n4 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n4) : string + keyStroke.getKeyChar();
        }
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n);
        this.paintBackground(graphics, jMenuItem, color);
        Color color3 = graphics.getColor();
        if ((jComponent.getUIClassID().indexOf("CheckBoxMenu") >= 0 || jComponent.getUIClassID().indexOf("RadioButtonMenu") >= 0) && icon != null) {
            this.paintCheckBox(jMenuItem, graphics, icon);
            graphics.setColor(color3);
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 1) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).rotate(-1.5707963267948966);
            ((Graphics2D)object).translate(-n2 + 1, 0);
            int n6 = VsnetMenuItemUI.iconRect.x;
            VsnetMenuItemUI.iconRect.x = VsnetMenuItemUI.iconRect.y;
            VsnetMenuItemUI.iconRect.y = n6;
        }
        this.paintIcon(jMenuItem, graphics);
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 1) {
            int n7 = VsnetMenuItemUI.iconRect.x;
            VsnetMenuItemUI.iconRect.x = VsnetMenuItemUI.iconRect.y;
            VsnetMenuItemUI.iconRect.y = n7;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -n2 + 1);
        }
        if (string2 != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, textRect);
            } else {
                this.paintText(graphics, jMenuItem, textRect, string2);
            }
        }
        if (string != null && !string.equals("")) {
            int n8 = 0;
            Container container = this.menuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n9 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
                int n10 = n9 != null ? n9 : VsnetMenuItemUI.acceleratorRect.width;
                n8 = n10 - VsnetMenuItemUI.acceleratorRect.width;
            }
            if (!container.getComponentOrientation().isLeftToRight()) {
                n8 = 0;
            }
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, VsnetMenuItemUI.acceleratorRect.x - n8, VsnetMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, VsnetMenuItemUI.acceleratorRect.x - n8, VsnetMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    JideSwingUtilities.drawString(this.menuItem, graphics, string, VsnetMenuItemUI.acceleratorRect.x - n8 - 1, VsnetMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                JideSwingUtilities.drawString(this.menuItem, graphics, string, VsnetMenuItemUI.acceleratorRect.x - n8, VsnetMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.useCheckAndArrow()) {
                icon2.paintIcon(jComponent, graphics, VsnetMenuItemUI.arrowIconRect.x, VsnetMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont((Font)serializable2);
    }

    protected void paintCheckBox(JMenuItem jMenuItem, Graphics graphics, Icon icon) {
        ButtonModel buttonModel = jMenuItem.getModel();
        boolean bl = false;
        if (jMenuItem instanceof JCheckBoxMenuItem) {
            bl = jMenuItem.isSelected();
        } else if (jMenuItem instanceof JRadioButtonMenuItem) {
            bl = jMenuItem.isSelected();
        }
        if (bl) {
            if (buttonModel.isArmed() || buttonModel.isSelected()) {
                this.getPainter().paintMenuItemBackground(jMenuItem, graphics, checkIconRect, 0, 1);
                if (jMenuItem.getIcon() == null) {
                    icon.paintIcon(jMenuItem, graphics, VsnetMenuItemUI.checkIconRect.x, VsnetMenuItemUI.checkIconRect.y);
                }
            } else {
                this.getPainter().paintMenuItemBackground(jMenuItem, graphics, checkIconRect, 0, 3);
                if (jMenuItem.getIcon() == null) {
                    icon.paintIcon(jMenuItem, graphics, VsnetMenuItemUI.checkIconRect.x, VsnetMenuItemUI.checkIconRect.y);
                }
            }
        }
    }

    protected void paintIcon(JMenuItem jMenuItem, Graphics graphics) {
        if (jMenuItem.getIcon() != null) {
            Icon icon = this.getIcon(jMenuItem);
            ButtonModel buttonModel = jMenuItem.getModel();
            if (icon != null) {
                if (this.isFloatingIcon()) {
                    if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                        if (icon instanceof ImageIcon) {
                            ImageIcon imageIcon = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                            imageIcon.paintIcon(jMenuItem, graphics, VsnetMenuItemUI.iconRect.x + 1, VsnetMenuItemUI.iconRect.y + 1);
                        } else {
                            ImageIcon imageIcon = IconsFactory.createGrayImage(jMenuItem, icon);
                            imageIcon.paintIcon(jMenuItem, graphics, VsnetMenuItemUI.iconRect.x + 1, VsnetMenuItemUI.iconRect.y + 1);
                        }
                        icon.paintIcon(jMenuItem, graphics, VsnetMenuItemUI.iconRect.x - 1, VsnetMenuItemUI.iconRect.y - 1);
                    } else {
                        icon.paintIcon(jMenuItem, graphics, VsnetMenuItemUI.iconRect.x, VsnetMenuItemUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(jMenuItem, graphics, VsnetMenuItemUI.iconRect.x, VsnetMenuItemUI.iconRect.y);
                }
            }
        }
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        int n;
        int n2;
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n2 = jMenuItem.getWidth();
            n = jMenuItem.getHeight();
        } else {
            n2 = jMenuItem.getHeight();
            n = jMenuItem.getWidth();
        }
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getComponentOrientation().isLeftToRight()) {
                if (jMenuItem.getBackground() instanceof UIResource) {
                    graphics.setColor(this.getPainter().getMenuItemBackground());
                } else {
                    graphics.setColor(jMenuItem.getBackground());
                }
                graphics.fillRect(this.defaultShadowWidth, 0, n2 - this.defaultShadowWidth, n);
                this.getPainter().paintMenuShadow(jMenuItem, graphics, new Rectangle(0, 0, this.defaultShadowWidth, n), 0, 0);
                if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                    this.getPainter().paintMenuItemBackground(jMenuItem, graphics, new Rectangle(1, 0, n2 - 2, n), 0, 2);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillSingleGradient(graphics, new Rectangle(0, 0, this.defaultShadowWidth, n), 3, 255);
                }
                graphics.setColor(color2);
            } else {
                if (jMenuItem.getBackground() instanceof UIResource) {
                    graphics.setColor(this.getPainter().getMenuItemBackground());
                } else {
                    graphics.setColor(jMenuItem.getBackground());
                }
                graphics.fillRect(0, 0, n2 - this.defaultShadowWidth, n);
                this.getPainter().paintMenuShadow(jMenuItem, graphics, new Rectangle(n2 - this.defaultShadowWidth, 0, this.defaultShadowWidth, n), 0, 0);
                if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                    this.getPainter().paintMenuItemBackground(jMenuItem, graphics, new Rectangle(0, 0, n2, n), 0, 2);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillSingleGradient(graphics, new Rectangle(n2 - this.defaultShadowWidth, 0, this.defaultShadowWidth, n), 7, 255);
                }
                graphics.setColor(color2);
            }
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (!buttonModel.isEnabled()) {
            WindowsGraphicsUtils.paintText((Graphics)graphics, (AbstractButton)jMenuItem, (Rectangle)rectangle, (String)string, (int)0);
        } else {
            int n = jMenuItem.getDisplayedMnemonicIndex();
            if (SystemInfo.isMnemonicHidden()) {
                n = -1;
            }
            Color color = graphics.getColor();
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(color);
        }
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        Object object;
        if (icon != null && (icon.getIconHeight() == 0 || icon.getIconWidth() == 0)) {
            icon = null;
        }
        rectangle.width -= this.getRightMargin();
        String string3 = SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (this.getRightMargin() > 0) {
            string = string3;
        }
        rectangle.width += this.getRightMargin();
        Insets insets = this.isDownArrowVisible(this.menuItem.getParent()) ? new Insets(0, 0, 0, 0) : this.menuItem.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            rectangle.height = this.menuItem.getHeight() - insets.top - insets.bottom;
            rectangle.width = this.menuItem.getWidth() - insets.left - insets.right;
        } else {
            rectangle.height = this.menuItem.getWidth() - insets.top - insets.bottom;
            rectangle.width = this.menuItem.getHeight() - insets.left - insets.right;
        }
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (string == null || string.equals("")) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            Object object2 = object = this.menuItem != null ? (View)this.menuItem.getClientProperty("html") : null;
            if (object != null) {
                rectangle3.width = (int)((View)object).getPreferredSpan(0);
                rectangle3.height = (int)((View)object).getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        if (icon == null) {
            if (this.useCheckAndArrow()) {
                rectangle2.height = 16;
                rectangle2.width = 16;
            } else {
                rectangle2.height = 0;
                rectangle2.width = 0;
            }
        } else {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        }
        if (icon3 == null) {
            rectangle6.height = 0;
            rectangle6.width = 0;
        } else {
            try {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            }
            catch (Exception exception) {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        if (icon2 == null) {
            rectangle5.height = 0;
            rectangle5.width = 0;
        } else {
            try {
                rectangle5.width = icon != null ? icon.getIconWidth() : icon2.getIconWidth();
                rectangle5.height = icon != null ? icon.getIconHeight() : icon2.getIconHeight();
            }
            catch (Exception exception) {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
        }
        if (this.useCheckAndArrow()) {
            rectangle2.x = this.defaultShadowWidth - rectangle2.width >> 1;
            if (string != null && !string.equals("")) {
                rectangle3.x = rectangle.x + this.defaultShadowWidth + n5;
            }
        }
        rectangle4.x = rectangle.x + rectangle.width - n6 - rectangle4.width;
        if (this.useCheckAndArrow()) {
            rectangle5.x = rectangle.x + (this.defaultShadowWidth - rectangle5.width) >> 1;
            rectangle6.x = rectangle.x + rectangle.width - n6 - 5 - rectangle6.width;
        }
        if (n3 == 0 && n == 0) {
            if (string != null && !string.equals("")) {
                rectangle3.y = rectangle.y + (rectangle.height - rectangle3.height >> 1);
            }
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height >> 1);
        }
        object = rectangle2.union(rectangle3);
        rectangle4.y = ((Rectangle)object).y + (((Rectangle)object).height >> 1) - (rectangle4.height >> 1);
        if (this.useCheckAndArrow()) {
            rectangle6.y = rectangle.y + (rectangle.height - rectangle6.height >> 1);
            rectangle5.y = rectangle.y + (rectangle.height - rectangle5.height >> 1);
        }
        if ((this.useCheckAndArrow() || this.menuItem instanceof JideSplitButton) && !this.menuItem.getComponentOrientation().isLeftToRight()) {
            rectangle5.x = rectangle.width - rectangle5.width - rectangle5.x;
            rectangle2.x = rectangle.width - rectangle2.width - rectangle2.x;
            rectangle3.x = rectangle.width - rectangle3.width - rectangle3.x;
            rectangle4.x = rectangle.width - rectangle4.width - rectangle4.x;
            rectangle6.x = rectangle.width - rectangle6.width - rectangle6.x;
        }
        return string;
    }

    protected boolean useCheckAndArrow() {
        boolean bl = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2;
            for (n2 = menuElementArray2.length - 1; n2 >= 0 && menuElementArray2[n2].getComponent() != container; --n2) {
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    protected ThemePainter getPainter() {
        return this._painter;
    }

    protected boolean isDownArrowVisible(Container container) {
        if (container instanceof TopLevelMenuContainer && ((TopLevelMenuContainer)((Object)container)).isMenuBar()) {
            return false;
        }
        if (container instanceof TopLevelMenuContainer && !((TopLevelMenuContainer)((Object)container)).isMenuBar()) {
            return true;
        }
        return !(container instanceof JMenuBar);
    }

    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    protected Icon getIcon(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (!buttonModel.isEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            if (icon2 == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(abstractButton, icon);
            }
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 != null) {
                // empty if block
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (icon2 != null) {
            icon = icon2;
        }
        return icon;
    }

    protected int getRightMargin() {
        return 0;
    }

    private static class ClickAction
    extends AbstractAction {
        private static final long serialVersionUID = -8707660318949717143L;

        private ClickAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("labelFor") || string.equals("displayedMnemonic") || string.equals("accelerator")) {
                VsnetMenuItemUI.this.updateAcceleratorBinding();
            } else if ("buttonStyle".equals(string) || "opaque".equals(string) || "contentAreaFilled".equals(string)) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                jMenuItem.repaint();
            } else if (string.equals("orientation")) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                jMenuItem.invalidate();
                jMenuItem.repaint();
            } else if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                int n = VsnetMenuItemUI.this.menuItem.getMnemonic();
                if (n == 0 || menuKeyEvent.getPath().length != 2) {
                    return;
                }
                if (this.lower((char)n) == this.lower(menuKeyEvent.getKeyChar())) {
                    MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                    VsnetMenuItemUI.this.doClick(menuSelectionManager);
                    menuKeyEvent.consume();
                }
            }
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char lower(char c) {
            return Character.toLowerCase(c);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
                MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
                Point point = menuDragMouseEvent.getPoint();
                if (point.x >= 0 && point.x < VsnetMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < VsnetMenuItemUI.this.menuItem.getHeight()) {
                    VsnetMenuItemUI.this.doClick(menuSelectionManager);
                } else {
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                Point point = mouseEvent.getPoint();
                if (point.x >= 0 && point.x < VsnetMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < VsnetMenuItemUI.this.menuItem.getHeight()) {
                    VsnetMenuItemUI.this.doClick(menuSelectionManager);
                } else {
                    menuSelectionManager.processMouseEvent(mouseEvent);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n = mouseEvent.getModifiers();
                if ((n & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                } else {
                    menuSelectionManager.setSelectedPath(VsnetMenuItemUI.this.getPath());
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n = mouseEvent.getModifiers();
                if ((n & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                } else {
                    MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                    if (menuElementArray.length > 1) {
                        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                        int n2 = menuElementArray.length - 1;
                        for (int i = 0; i < n2; ++i) {
                            menuElementArray2[i] = menuElementArray[i];
                        }
                        menuSelectionManager.setSelectedPath(menuElementArray2);
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n = mouseEvent.getModifiers();
                if ((n & 0x1C) == 0) {
                    MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                    if (VsnetMenuItemUI.this.getPath().length > menuElementArray.length) {
                        menuSelectionManager.setSelectedPath(VsnetMenuItemUI.this.getPath());
                    }
                }
            }
        }
    }
}

