/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.Serializable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.multisearch.AbstractEvaluationTask;
import weka.classifiers.meta.multisearch.AbstractEvaluationWrapper;
import weka.classifiers.meta.multisearch.MultiSearchCapable;
import weka.classifiers.meta.multisearch.Performance;
import weka.core.Instances;
import weka.core.SetupGenerator;
import weka.core.setupgenerator.Point;

public class DefaultEvaluationTask
extends AbstractEvaluationTask {
    public DefaultEvaluationTask(MultiSearchCapable owner, Instances train, Instances test, SetupGenerator generator, Point<Object> values, int folds, int eval, int classLabel) {
        super(owner, train, test, generator, values, folds, eval, classLabel);
    }

    protected boolean canDiscardPredictions() {
        switch (this.m_Owner.getEvaluation().getSelectedTag().getID()) {
            case 8: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Boolean doRun() throws Exception {
        boolean completed;
        Evaluation eval;
        Point<Object> evals = this.m_Generator.evaluate(this.m_Values);
        Classifier classifier = (Classifier)this.m_Generator.setup((Serializable)this.m_Owner.getClassifier(), evals);
        try {
            eval = new Evaluation(this.m_Train);
            eval.setDiscardPredictions(this.canDiscardPredictions());
            if (this.m_Test == null) {
                if (this.m_Folds >= 2) {
                    eval.crossValidateModel(classifier, this.m_Train, this.m_Folds, new Random(this.m_Owner.getSeed()), new Object[0]);
                } else {
                    classifier.buildClassifier(this.m_Train);
                    eval.evaluateModel(classifier, this.m_Train, new Object[0]);
                }
            } else {
                classifier.buildClassifier(this.m_Train);
                eval.evaluateModel(classifier, this.m_Test, new Object[0]);
            }
            completed = true;
        }
        catch (Exception e) {
            eval = null;
            System.err.println("Encountered exception while evaluating classifier, skipping!");
            System.err.println("- Classifier: " + this.m_Owner.getCommandline(classifier));
            e.printStackTrace();
            completed = false;
        }
        Performance performance = new Performance(this.m_Values, (AbstractEvaluationWrapper)this.m_Owner.getFactory().newWrapper(eval), this.m_Evaluation, this.m_ClassLabel, (Classifier)this.m_Generator.setup((Serializable)this.m_Owner.getClassifier(), evals));
        this.m_Owner.getAlgorithm().addPerformance(performance, this.m_Folds);
        this.m_Owner.log(performance + ": cached=false");
        return completed;
    }
}

