/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.setupgenerator.AbstractPropertyParameter;

public class ListParameter
extends AbstractPropertyParameter {
    private static final long serialVersionUID = 1415901739037349037L;
    protected String m_CustomDelimiter = "";
    protected String m_ListStr = "";

    @Override
    public String globalInfo() {
        return "Container class defining the search parameters for a particular property.\nOnly the specified list values are used.\nA custom list delimiter can be defined as well. By default, a blank-separated list is used.";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm);
        }
        result.addElement(new Option("\tThe custom list delimiter.\n\t(default: none)", "custom-delimiter", 1, "-custom-delimiter <values>"));
        result.addElement(new Option("\tThe list of explicit values to use.\n\t(default: none)", "list", 1, "-list <values>"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (!this.getCustomDelimiter().isEmpty()) {
            result.add("-custom-delimiter");
            result.add("" + this.getCustomDelimiter());
        }
        result.add("-list");
        result.add("" + this.getList());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"custom-delimiter", (String[])options);
        if (tmpStr.length() != 0) {
            this.setCustomDelimiter(tmpStr);
        } else {
            this.setCustomDelimiter("");
        }
        tmpStr = Utils.getOption((String)"list", (String[])options);
        if (tmpStr.length() != 0) {
            this.setList(tmpStr);
        } else {
            this.setList("");
        }
        super.setOptions(options);
    }

    public String customerDelimiterTipText() {
        return "The custom list delimiter to use - blank-separated list by default.";
    }

    public String getCustomDelimiter() {
        return this.m_CustomDelimiter;
    }

    public void setCustomDelimiter(String value) {
        this.m_CustomDelimiter = value;
    }

    public String listTipText() {
        return "The blank-separated list of values to use.";
    }

    public String getList() {
        return this.m_ListStr;
    }

    public void setList(String value) {
        this.m_ListStr = value;
    }

    public String[] getItems() throws Exception {
        String[] result = this.getCustomDelimiter().isEmpty() ? Utils.splitOptions((String)this.getList()) : this.getList().split(this.getCustomDelimiter());
        return result;
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result + ", list: " + this.getList();
        if (!this.getCustomDelimiter().isEmpty()) {
            result = result + ", delimiter: '" + this.getCustomDelimiter() + "'";
        }
        return result;
    }
}

