/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.ListParameter;
import weka.core.setupgenerator.MathParameter;

public class ParameterGroup
extends AbstractParameter {
    private static final long serialVersionUID = -8833890695683415205L;
    protected AbstractParameter[] m_Parameters = new AbstractParameter[0];

    @Override
    public String globalInfo() {
        return "Groups dependent parameters.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tA parameter setup for generating the setups.\n\tCan be supplied multiple times.\n\t(default: " + AbstractParameter.class.getName() + ")", "search", 1, "-search <classname options>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to search parameter class '" + MathParameter.class.getName() + "' ('-search'):"));
        Enumeration en = new MathParameter().listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("", "", 0, "\nOptions specific to search parameter class '" + ListParameter.class.getName() + "' ('-search'):"));
        en = new ListParameter().listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.m_Parameters.length; ++i) {
            result.add("-search");
            String tmpStr = this.m_Parameters[i].getClass().getName() + " " + Utils.joinOptions((String[])this.m_Parameters[i].getOptions());
            result.add(tmpStr);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        Vector<String> search = new Vector<String>();
        do {
            if ((tmpStr = Utils.getOption((String)"search", (String[])options)).length() <= 0) continue;
            search.add(tmpStr);
        } while (tmpStr.length() > 0);
        if (search.size() == 0) {
            throw new IllegalArgumentException("No search parameters provided!");
        }
        AbstractParameter[] params = new AbstractParameter[search.size()];
        for (int i = 0; i < search.size(); ++i) {
            String[] tmpOptions = Utils.splitOptions((String)((String)search.get(i)));
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            params[i] = (AbstractParameter)Utils.forName(AbstractParameter.class, (String)tmpStr, (String[])tmpOptions);
        }
        this.setParameters(params);
    }

    public String parametersFileTipText() {
        return "The parameter definitions.";
    }

    public void setParameters(AbstractParameter[] value) {
        this.m_Parameters = value;
    }

    public AbstractParameter[] getParameters() {
        return this.m_Parameters;
    }

    @Override
    public String toString() {
        return Utils.arrayToString((Object)this.m_Parameters);
    }
}

