/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.setupgenerator.AbstractPropertyParameter;
import weka.core.setupgenerator.ListSpaceDimension;
import weka.core.setupgenerator.SpaceDimension;

public class MLPLayersParameter
extends AbstractPropertyParameter {
    private static final long serialVersionUID = -5119694776105238138L;
    public static final int MAX_CANDIDATES_TO_GENERATE = 65536;
    protected static final int MIN_LAYERS_DEFAULT = 1;
    protected static final int MAX_LAYERS_DEFAULT = 2;
    protected static final int MIN_LAYER_SIZE_DEFAULT = 8;
    protected static final int MAX_LAYER_SIZE_DEFAULT = 128;
    protected int m_MinLayers = 1;
    protected int m_MaxLayers = 2;
    protected int m_MinLayerSize = 8;
    protected int m_MaxLayerSize = 128;

    @Override
    public String globalInfo() {
        return "Container class defining the hiddenLayer search parameter of the MultiLayerPerceptron.\nGiven minLayers, maxLayers, minLayerSize and maxLayerSize, it generates a comma-separated string s integers, such that minLayers <= s <= maxLayers, and for every integer n minLayerSize <= n <= maxLayerSize. ";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm);
        }
        result.addElement(new Option("\tThe minimum number of layers.\n\t(default: 1)", "minLayers", 1, "-minLayers <value>"));
        result.addElement(new Option("\tThe maximal number of layers.\n\t(default: 2)", "maxLayers", 2, "-maxLayers <value>"));
        result.addElement(new Option("\tTThe minimum size for each layer.\n\t(default: 8)", "minLayerSize", 8, "-minLayerSize <value>"));
        result.addElement(new Option("\tTThe maximal size for each layer.\n\t(default: 128)", "maxLayerSize", 128, "-maxLayerSize <value>"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-minLayers");
        result.add("" + this.getMinLayers());
        result.add("-maxLayers");
        result.add("" + this.getMaxLayers());
        result.add("-minLayerSize");
        result.add("" + this.getMinLayerSize());
        result.add("-maxLayerSize");
        result.add("" + this.getMaxLayerSize());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"minLayers", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMinLayers(Integer.parseInt(tmpStr));
        } else {
            this.setMinLayers(1);
        }
        tmpStr = Utils.getOption((String)"maxLayers", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMaxLayers(Integer.parseInt(tmpStr));
        } else {
            this.setMaxLayers(2);
        }
        tmpStr = Utils.getOption((String)"minLayerSize", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMinLayerSize(Integer.parseInt(tmpStr));
        } else {
            this.setMinLayerSize(8);
        }
        tmpStr = Utils.getOption((String)"maxLayerSize", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMaxLayerSize(Integer.parseInt(tmpStr));
        } else {
            this.setMaxLayerSize(8);
        }
        this.checkStructureParams();
        super.setOptions(options);
    }

    public String minLayersTipText() {
        return "The minimal number of layers to generate";
    }

    public int getMinLayers() {
        return this.m_MinLayers;
    }

    public void setMinLayers(int minLayers) {
        this.m_MinLayers = minLayers;
    }

    public String maxLayersTipText() {
        return "The maximal number of layers to generate";
    }

    public int getMaxLayers() {
        return this.m_MaxLayers;
    }

    public void setMaxLayers(int maxLayers) {
        this.m_MaxLayers = maxLayers;
    }

    public String minLayerSizeTipText() {
        return "The minimum size of each layer";
    }

    public int getMinLayerSize() {
        return this.m_MinLayerSize;
    }

    public void setMinLayerSize(int minLayerSize) {
        this.m_MinLayerSize = minLayerSize;
    }

    public String maxLayerSizeTipText() {
        return "The maximum size of each layer";
    }

    public int getMaxLayerSize() {
        return this.m_MaxLayerSize;
    }

    public void setMaxLayerSize(int maxLayerSize) {
        this.m_MaxLayerSize = maxLayerSize;
    }

    public long calculateNumberOfCandidates() {
        long result = 0L;
        for (int i = this.getMinLayers(); i <= this.getMaxLayers(); ++i) {
            result = (long)((double)result + Math.pow(this.getMaxLayerSize() - this.getMinLayerSize() + 1, i));
        }
        return result;
    }

    private void checkStructureParams() throws Exception {
        if (this.getMaxLayerSize() < this.getMinLayerSize()) {
            throw new Exception("minLayerSize should be smaller than or equal to maxLayerSize");
        }
        if (this.getMaxLayers() < this.getMinLayers()) {
            throw new Exception("minLayers should be smaller than or equal to maxLayers");
        }
        if (this.getMaxLayers() == this.getMinLayers() && this.getMaxLayerSize() == this.getMinLayerSize()) {
            throw new Exception("no variation in layer structure possible");
        }
    }

    private String implodeList(List<Integer> list, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Integer i : list) {
            sb.append(delimiter + i);
        }
        return sb.toString().substring(delimiter.length());
    }

    private HashSet<String> generateCandicatesRandom(int numCandidates, long seed) {
        Random random = new Random(seed);
        HashSet<String> result = new HashSet<String>();
        block0: while (result.size() < numCandidates) {
            ArrayList<Integer> current = new ArrayList<Integer>();
            while (current.size() < this.getMaxLayers()) {
                int range = this.getMaxLayerSize() - this.getMinLayerSize() + 1;
                int currentLayerSize = random.nextInt(range) + this.getMinLayerSize();
                current.add(currentLayerSize);
                if (current.size() <= this.getMinLayers()) continue;
                String currentAsStr = this.implodeList(current, ",");
                result.add(currentAsStr);
                if (result.size() < numCandidates) continue;
                continue block0;
            }
        }
        return result;
    }

    private ArrayList<String> generateCandidatesExhaustive(ArrayList<Integer> currentLayers) {
        if (currentLayers.size() >= this.getMaxLayers()) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.implodeList(currentLayers, ","));
            return result;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (currentLayers.size() >= this.getMinLayers()) {
            result.add(this.implodeList(currentLayers, ","));
        }
        for (int i = this.getMinLayerSize(); i <= this.getMaxLayerSize(); ++i) {
            currentLayers.add(i);
            result.addAll(this.generateCandidatesExhaustive(currentLayers));
            currentLayers.remove(currentLayers.size() - 1);
        }
        return result;
    }

    public String[] getItems() throws Exception {
        this.checkStructureParams();
        AbstractCollection result = this.calculateNumberOfCandidates() >= 65536L ? this.generateCandicatesRandom(65536, 0L) : this.generateCandidatesExhaustive(new ArrayList<Integer>());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public SpaceDimension spaceDimension() throws Exception {
        String[] items = this.getItems();
        return new ListSpaceDimension(0, items.length - 1, items, this.getProperty());
    }

    @Override
    public Object evaluate(Object point) {
        return point;
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result + ", minLayers: " + this.m_MinLayers;
        result = result + ", maxLayers: " + this.m_MaxLayers;
        result = result + ", minLayerSize: " + this.m_MinLayerSize;
        result = result + ", maxLayerSize: " + this.m_MaxLayerSize;
        return result;
    }
}

