/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.expressionlanguage.common.IfElseMacro;
import weka.core.expressionlanguage.common.JavaMacro;
import weka.core.expressionlanguage.common.MacroDeclarationsCompositor;
import weka.core.expressionlanguage.common.MathFunctions;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.common.SimpleVariableDeclarations;
import weka.core.expressionlanguage.common.VariableDeclarationsCompositor;
import weka.core.expressionlanguage.core.MacroDeclarations;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.VariableDeclarations;
import weka.core.expressionlanguage.parser.Parser;
import weka.core.setupgenerator.AbstractPropertyParameter;
import weka.core.setupgenerator.FunctionSpaceDimension;
import weka.core.setupgenerator.SpaceDimension;

public class MathParameter
extends AbstractPropertyParameter {
    private static final long serialVersionUID = 6430400142112674316L;
    protected double m_Min = 1.0;
    protected double m_Max = 5.0;
    protected double m_Step = 1.0;
    protected double m_Base = 10.0;
    protected String m_Expression = "pow(BASE,I)";

    @Override
    public String globalInfo() {
        return "Container class defining the search parameters for a particular property.\nThe expression is a mathematical expression that uses the following variables:\n  BASE\n  FROM (= min)\n  TO (= max)\n  STEP\n  I - the current value (from 'from' to 'to' with stepsize 'step')\nFor more information on the allowed mathematical operations, see Javadoc of the following classes:\n " + MathFunctions.class.getName() + "\n" + IfElseMacro.class.getName() + "\n" + JavaMacro.class.getName() + ".";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tThe minimum.\n\t(default: -10)", "min", 1, "-min <num>"));
        result.addElement(new Option("\tThe maximum.\n\t(default: +5)", "max", 1, "-max <num>"));
        result.addElement(new Option("\tThe step size.\n\t(default: 1)", "step", 1, "-step <num>"));
        result.addElement(new Option("\tThe base.\n\t(default: 10)", "base", 1, "-base <num>"));
        result.addElement(new Option("\tThe expression.\n\tAvailable parameters:\n\t\tBASE\n\t\tFROM\n\t\tTO\n\t\tSTEP\n\t\tI - the current iteration value\n\t\t(from 'FROM' to 'TO' with stepsize 'STEP')\n\t(default: 'pow(BASE,I)')", "expression", 1, "-expression <expr>"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-min");
        result.add("" + this.getMin());
        result.add("-max");
        result.add("" + this.getMax());
        result.add("-step");
        result.add("" + this.getStep());
        result.add("-base");
        result.add("" + this.getBase());
        result.add("-expression");
        result.add("" + this.getExpression());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"min", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMin(Double.parseDouble(tmpStr));
        } else {
            this.setMin(-10.0);
        }
        tmpStr = Utils.getOption((String)"max", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMax(Double.parseDouble(tmpStr));
        } else {
            this.setMax(10.0);
        }
        tmpStr = Utils.getOption((String)"step", (String[])options);
        if (tmpStr.length() != 0) {
            this.setStep(Double.parseDouble(tmpStr));
        } else {
            this.setStep(1.0);
        }
        tmpStr = Utils.getOption((String)"base", (String[])options);
        if (tmpStr.length() != 0) {
            this.setBase(Double.parseDouble(tmpStr));
        } else {
            this.setBase(10.0);
        }
        tmpStr = Utils.getOption((String)"expression", (String[])options);
        if (tmpStr.length() != 0) {
            this.setExpression(tmpStr);
        } else {
            this.setExpression("pow(BASE,I)");
        }
        super.setOptions(options);
    }

    public String minTipText() {
        return "The minimum.";
    }

    public double getMin() {
        return this.m_Min;
    }

    public void setMin(double value) {
        this.m_Min = value;
    }

    public String maxTipText() {
        return "The maximum.";
    }

    public double getMax() {
        return this.m_Max;
    }

    public void setMax(double value) {
        this.m_Max = value;
    }

    public String stepTipText() {
        return "The step size.";
    }

    public double getStep() {
        return this.m_Step;
    }

    public void setStep(double value) {
        this.m_Step = value;
    }

    public String baseTipText() {
        return "The base of X.";
    }

    public double getBase() {
        return this.m_Base;
    }

    public void setBase(double value) {
        this.m_Base = value;
    }

    public String expressionTipText() {
        return "The expression for the value (parameters: BASE, FROM, TO, STEP, I).";
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public void setExpression(String value) {
        this.m_Expression = value;
    }

    @Override
    public SpaceDimension spaceDimension() throws Exception {
        return new FunctionSpaceDimension(this.m_Min, this.m_Max, this.m_Step, this.getProperty());
    }

    @Override
    public Object evaluate(Object point) {
        try {
            SimpleVariableDeclarations vars = new SimpleVariableDeclarations();
            vars.addDouble("BASE");
            vars.addDouble("FROM");
            vars.addDouble("TO");
            vars.addDouble("STEP");
            vars.addDouble("I");
            Node node = Parser.parse((String)this.getExpression(), (VariableDeclarations)new VariableDeclarationsCompositor(new VariableDeclarations[]{vars}), (MacroDeclarations)new MacroDeclarationsCompositor(new MacroDeclarations[]{new MathFunctions(), new IfElseMacro(), new JavaMacro()}));
            if (!(node instanceof Primitives.DoubleExpression)) {
                throw new Exception("Expression must be of type double!");
            }
            SimpleVariableDeclarations.VariableInitializer curVars = vars.getInitializer();
            if (curVars.hasVariable("BASE")) {
                curVars.setDouble("BASE", this.getBase());
            }
            if (curVars.hasVariable("FROM")) {
                curVars.setDouble("FROM", this.getMin());
            }
            if (curVars.hasVariable("TO")) {
                curVars.setDouble("TO", this.getMax());
            }
            if (curVars.hasVariable("STEP")) {
                curVars.setDouble("STEP", this.getStep());
            }
            if (curVars.hasVariable("I")) {
                curVars.setDouble("I", ((Double)point).doubleValue());
            }
            Primitives.DoubleExpression compiled = (Primitives.DoubleExpression)node;
            return compiled.evaluate();
        }
        catch (Exception e) {
            System.err.println("Failed to evaluate '" + this.getExpression() + "' using base=" + this.getBase() + ", from=" + this.getMin() + ", to=" + this.getMax() + ", step=" + this.getStep() + ", i=" + point);
            e.printStackTrace();
            return Double.NaN;
        }
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result + ", min: " + this.getMin() + ", max: " + this.getMax() + ", step: " + this.getStep() + ", base: " + this.getBase() + ", expr: " + this.getExpression();
        return result;
    }
}

