/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.dsp;

import com.musicg.dsp.LinearInterpolation;

public class Resampler {
    public byte[] reSample(byte[] sourceData, int bitsPerSample, int sourceRate, int targetRate) {
        byte[] bytes;
        int bytePerSample = bitsPerSample / 8;
        int numSamples = sourceData.length / bytePerSample;
        short[] amplitudes = new short[numSamples];
        int pointer = 0;
        for (int i = 0; i < numSamples; ++i) {
            short amplitude = 0;
            for (int byteNumber = 0; byteNumber < bytePerSample; ++byteNumber) {
                amplitude = (short)(amplitude | (short)((sourceData[pointer++] & 0xFF) << byteNumber * 8));
            }
            amplitudes[i] = amplitude;
        }
        LinearInterpolation reSample = new LinearInterpolation();
        short[] targetSample = reSample.interpolate(sourceRate, targetRate, amplitudes);
        int targetLength = targetSample.length;
        if (bytePerSample == 1) {
            bytes = new byte[targetLength];
            for (int i = 0; i < targetLength; ++i) {
                bytes[i] = (byte)targetSample[i];
            }
        } else {
            bytes = new byte[targetLength * 2];
            for (int i = 0; i < targetSample.length; ++i) {
                bytes[i * 2] = (byte)(targetSample[i] & 0xFF);
                bytes[i * 2 + 1] = (byte)(targetSample[i] >> 8 & 0xFF);
            }
        }
        return bytes;
    }
}

