/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.dsp;

public class WindowFunction {
    public static final int RECTANGULAR = 0;
    public static final int BARTLETT = 1;
    public static final int HANNING = 2;
    public static final int HAMMING = 3;
    public static final int BLACKMAN = 4;
    int windowType = 0;

    public void setWindowType(int wt) {
        this.windowType = wt;
    }

    public void setWindowType(String w) {
        if (w.toUpperCase().equals("RECTANGULAR")) {
            this.windowType = 0;
        }
        if (w.toUpperCase().equals("BARTLETT")) {
            this.windowType = 1;
        }
        if (w.toUpperCase().equals("HANNING")) {
            this.windowType = 2;
        }
        if (w.toUpperCase().equals("HAMMING")) {
            this.windowType = 3;
        }
        if (w.toUpperCase().equals("BLACKMAN")) {
            this.windowType = 4;
        }
    }

    public int getWindowType() {
        return this.windowType;
    }

    public double[] generate(int nSamples) {
        int m = nSamples / 2;
        double pi = Math.PI;
        double[] w = new double[nSamples];
        switch (this.windowType) {
            case 1: {
                for (int n = 0; n < nSamples; ++n) {
                    w[n] = 1.0f - (float)(Math.abs(n - m) / m);
                }
                break;
            }
            case 2: {
                double r = pi / (double)(m + 1);
                for (int n = -m; n < m; ++n) {
                    w[m + n] = 0.5 + 0.5 * Math.cos((double)n * r);
                }
                break;
            }
            case 3: {
                double r = pi / (double)m;
                for (int n = -m; n < m; ++n) {
                    w[m + n] = (double)0.54f + (double)0.46f * Math.cos((double)n * r);
                }
                break;
            }
            case 4: {
                double r = pi / (double)m;
                for (int n = -m; n < m; ++n) {
                    w[m + n] = (double)0.42f + 0.5 * Math.cos((double)n * r) + (double)0.08f * Math.cos((double)(2 * n) * r);
                }
                break;
            }
            default: {
                for (int n = 0; n < nSamples; ++n) {
                    w[n] = 1.0;
                }
            }
        }
        return w;
    }
}

