/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.experiment.math.cluster;

import com.musicg.experiment.math.cluster.Segment;
import com.musicg.pitch.PitchHandler;
import java.util.LinkedList;
import java.util.List;

public class SegmentCluster {
    private double diffThreshold;

    public SegmentCluster() {
        this.diffThreshold = 1.0;
    }

    public SegmentCluster(double diffThreshold) {
        this.diffThreshold = diffThreshold;
    }

    public void setDiffThreshold(double diffThreshold) {
        this.diffThreshold = diffThreshold;
    }

    public List<Segment> getSegments(double[] array) {
        PitchHandler pitchHandler = new PitchHandler();
        LinkedList<Segment> segmentList = new LinkedList<Segment>();
        double segmentMean = 0.0;
        int segmentSize = 0;
        if (array.length > 0) {
            segmentMean = array[1];
            segmentSize = 1;
        }
        for (int i = 1; i < array.length; ++i) {
            double diff = Math.abs(pitchHandler.getToneChanged(array[i], segmentMean));
            if (diff < this.diffThreshold) {
                segmentMean = (segmentMean * (double)segmentSize + array[i]) / (double)(++segmentSize);
                continue;
            }
            Segment segment = new Segment();
            segment.setMean(segmentMean);
            segment.setStartPosition(i - segmentSize);
            segment.setSize(segmentSize);
            segmentList.add(segment);
            segmentMean = array[i];
            segmentSize = 1;
        }
        Segment segment = new Segment();
        segment.setMean(segmentMean);
        segment.setStartPosition(array.length - segmentSize);
        segment.setSize(segmentSize);
        segmentList.add(segment);
        return segmentList;
    }
}

