/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.experiment.test;

import com.musicg.graphic.GraphicRender;
import com.musicg.math.rank.ArrayRankDouble;
import com.musicg.math.statistics.SpectralCentroid;
import com.musicg.math.statistics.StandardDeviation;
import com.musicg.pitch.PitchHandler;
import com.musicg.wave.Wave;
import com.musicg.wave.extension.Spectrogram;

public class Test1 {
    public static void main(String[] args) {
        Object[] temp;
        int i;
        String filename = "audio_work/lala.wav";
        Wave wave = new Wave(filename);
        int fftSampleSize = 1024;
        int overlapFactor = 1;
        Spectrogram spectrogram = new Spectrogram(wave, fftSampleSize, overlapFactor);
        int fps = spectrogram.getFramesPerSecond();
        double unitFrequency = spectrogram.getUnitFrequency();
        int highPass = 100;
        int lowerBoundary = (int)((double)highPass / unitFrequency);
        int lowPass = 4000;
        int upperBoundary = (int)((double)lowPass / unitFrequency);
        double[][] spectrogramData = spectrogram.getNormalizedSpectrogramData();
        double[][] absoluteSpectrogramData = spectrogram.getAbsoluteSpectrogramData();
        double[][] boundedSpectrogramData = new double[spectrogramData.length][];
        SpectralCentroid sc = new SpectralCentroid();
        StandardDeviation sd = new StandardDeviation();
        ArrayRankDouble arrayRankDouble = new ArrayRankDouble();
        short[] amps = wave.getSampleAmplitudes();
        int numFrame = amps.length / 1024;
        double[] zcrs = new double[numFrame];
        for (i = 0; i < numFrame; ++i) {
            temp = new short[1024];
            System.arraycopy(amps, i * 1024, temp, 0, temp.length);
            int numZC = 0;
            int size = temp.length;
            for (int j = 0; j < size - 1; ++j) {
                if ((temp[j] < 0 || temp[j + 1] >= 0) && (temp[j] >= 0 || temp[j + 1] < 0)) continue;
                ++numZC;
            }
            zcrs[i] = numZC;
        }
        for (i = 0; i < spectrogramData.length; ++i) {
            temp = new double[upperBoundary - lowerBoundary + 1];
            System.arraycopy(spectrogramData[i], lowerBoundary, temp, 0, temp.length);
            int maxIndex = arrayRankDouble.getMaxValueIndex((double[])temp);
            sd.setValues((double[])temp);
            double sdValue = sd.evaluate();
            System.out.println(i + " " + (double)i / (double)fps + "s\t" + maxIndex + "\t" + sdValue + "\t" + zcrs[i]);
            boundedSpectrogramData[i] = temp;
        }
        GraphicRender render = new GraphicRender();
        render.setHorizontalMarker(61);
        render.setVerticalMarker(200);
        render.renderSpectrogramData(boundedSpectrogramData, filename + ".jpg");
        PitchHandler ph = new PitchHandler();
        for (int frame = 0; frame < absoluteSpectrogramData.length; ++frame) {
            System.out.print("frame " + frame + ": ");
            double[] temp2 = new double[upperBoundary - lowerBoundary + 1];
            sd.setValues(temp2);
            double sdValue = sd.evaluate();
            double passSd = 0.1;
            if (sdValue < passSd) {
                System.arraycopy(spectrogramData[frame], lowerBoundary, temp2, 0, temp2.length);
                double maxFrequency = (double)arrayRankDouble.getMaxValueIndex(temp2) * unitFrequency;
                double passFrequency = 400.0;
                int numRobust = 2;
                double[] robustFrequencies = new double[numRobust];
                double nthValue = arrayRankDouble.getNthOrderedValue(temp2, numRobust, false);
                int count = 0;
                for (int b = lowerBoundary; b <= upperBoundary; ++b) {
                    if (!(spectrogramData[frame][b] >= nthValue)) continue;
                    robustFrequencies[count++] = (double)b * unitFrequency;
                    if (count >= numRobust) break;
                }
                double passIntensity = 1000.0;
                double intensity = 0.0;
                for (int i2 = 0; i2 < absoluteSpectrogramData[frame].length; ++i2) {
                    intensity += absoluteSpectrogramData[frame][i2];
                }
                System.out.print(" intensity: " + (intensity /= (double)absoluteSpectrogramData[frame].length) + " pitch: " + maxFrequency);
                if (intensity > passIntensity && maxFrequency > passFrequency) {
                    double p = ph.getHarmonicProbability(robustFrequencies);
                    System.out.print(" P: " + p);
                }
            }
            System.out.print(" zcr:" + zcrs[frame]);
            System.out.println();
        }
    }
}

