/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.fingerprint;

import com.musicg.fingerprint.FingerprintManager;
import com.musicg.math.quicksort.QuickSortIndexPreserved;
import com.musicg.properties.FingerprintProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PairManager {
    FingerprintProperties fingerprintProperties = FingerprintProperties.getInstance();
    private int numFilterBanks = this.fingerprintProperties.getNumFilterBanks();
    private int bandwidthPerBank = this.fingerprintProperties.getNumFrequencyUnits() / this.numFilterBanks;
    private int anchorPointsIntervalLength = this.fingerprintProperties.getAnchorPointsIntervalLength();
    private int numAnchorPointsPerInterval = this.fingerprintProperties.getNumAnchorPointsPerInterval();
    private int maxTargetZoneDistance = this.fingerprintProperties.getMaxTargetZoneDistance();
    private int numFrequencyUnits = this.fingerprintProperties.getNumFrequencyUnits();
    private int maxPairs;
    private boolean isReferencePairing;
    private HashMap<Integer, Boolean> stopPairTable = new HashMap();

    public PairManager() {
        this.maxPairs = this.fingerprintProperties.getRefMaxActivePairs();
        this.isReferencePairing = true;
    }

    public PairManager(boolean isReferencePairing) {
        this.maxPairs = isReferencePairing ? this.fingerprintProperties.getRefMaxActivePairs() : this.fingerprintProperties.getSampleMaxActivePairs();
        this.isReferencePairing = isReferencePairing;
    }

    public HashMap<Integer, List<Integer>> getPair_PositionList_Table(byte[] fingerprint) {
        List<int[]> pairPositionList = this.getPairPositionList(fingerprint);
        HashMap<Integer, List<Integer>> pair_positionList_table = new HashMap<Integer, List<Integer>>();
        for (int[] pair_position : pairPositionList) {
            if (pair_positionList_table.containsKey(pair_position[0])) {
                pair_positionList_table.get(pair_position[0]).add(pair_position[1]);
                continue;
            }
            LinkedList<Integer> positionList = new LinkedList<Integer>();
            positionList.add(pair_position[1]);
            pair_positionList_table.put(pair_position[0], positionList);
        }
        return pair_positionList_table;
    }

    private List<int[]> getPairPositionList(byte[] fingerprint) {
        int numFrames = FingerprintManager.getNumFrames(fingerprint);
        byte[] pairedFrameTable = new byte[numFrames / this.anchorPointsIntervalLength + 1];
        LinkedList<int[]> pairList = new LinkedList<int[]>();
        List<int[]> sortedCoordinateList = this.getSortedCoordinateList(fingerprint);
        for (int[] anchorPoint : sortedCoordinateList) {
            int anchorX = anchorPoint[0];
            int anchorY = anchorPoint[1];
            int numPairs = 0;
            Iterator<int[]> targetPointListIterator = sortedCoordinateList.iterator();
            while (targetPointListIterator.hasNext() && numPairs < this.maxPairs && (!this.isReferencePairing || pairedFrameTable[anchorX / this.anchorPointsIntervalLength] < this.numAnchorPointsPerInterval)) {
                int y1;
                int x1;
                int y2;
                int x2;
                int[] targetPoint = targetPointListIterator.next();
                int targetX = targetPoint[0];
                int targetY = targetPoint[1];
                if (anchorX == targetX && anchorY == targetY) continue;
                if (targetX >= anchorX) {
                    x2 = targetX;
                    y2 = targetY;
                    x1 = anchorX;
                    y1 = anchorY;
                } else {
                    x2 = anchorX;
                    y2 = anchorY;
                    x1 = targetX;
                    y1 = targetY;
                }
                if (x2 - x1 > this.maxTargetZoneDistance || y1 / this.bandwidthPerBank != y2 / this.bandwidthPerBank) continue;
                int pairHashcode = (x2 - x1) * this.numFrequencyUnits * this.numFrequencyUnits + y2 * this.numFrequencyUnits + y1;
                if (!this.isReferencePairing && this.stopPairTable.containsKey(pairHashcode)) {
                    ++numPairs;
                    continue;
                }
                pairList.add(new int[]{pairHashcode, anchorX});
                int n = anchorX / this.anchorPointsIntervalLength;
                pairedFrameTable[n] = (byte)(pairedFrameTable[n] + 1);
                ++numPairs;
            }
        }
        return pairList;
    }

    private List<int[]> getSortedCoordinateList(byte[] fingerprint) {
        int numCoordinates = fingerprint.length / 8;
        int[] intensities = new int[numCoordinates];
        for (int i = 0; i < numCoordinates; ++i) {
            int intensity;
            int pointer = i * 8 + 4;
            intensities[i] = intensity = (fingerprint[pointer] & 0xFF) << 24 | (fingerprint[pointer + 1] & 0xFF) << 16 | (fingerprint[pointer + 2] & 0xFF) << 8 | fingerprint[pointer + 3] & 0xFF;
        }
        QuickSortIndexPreserved quicksort = new QuickSortIndexPreserved(intensities);
        int[] sortIndexes = quicksort.getSortIndexes();
        LinkedList<int[]> sortedCoordinateList = new LinkedList<int[]>();
        for (int i = sortIndexes.length - 1; i >= 0; --i) {
            int pointer = sortIndexes[i] * 8;
            int x = (fingerprint[pointer] & 0xFF) << 8 | fingerprint[pointer + 1] & 0xFF;
            int y = (fingerprint[pointer + 2] & 0xFF) << 8 | fingerprint[pointer + 3] & 0xFF;
            sortedCoordinateList.add(new int[]{x, y});
        }
        return sortedCoordinateList;
    }

    public static byte[] pairHashcodeToBytes(int pairHashcode) {
        return new byte[]{(byte)(pairHashcode >> 8), (byte)pairHashcode};
    }

    public static int pairBytesToHashcode(byte[] pairBytes) {
        return (pairBytes[0] & 0xFF) << 8 | pairBytes[1] & 0xFF;
    }
}

