/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.processor;

import com.musicg.math.rank.ArrayRankDouble;
import com.musicg.processor.IntensityProcessor;

public class RobustIntensityProcessor
implements IntensityProcessor {
    private double[][] intensities;
    private int numPointsPerFrame;

    public RobustIntensityProcessor(double[][] intensities, int numPointsPerFrame) {
        this.intensities = intensities;
        this.numPointsPerFrame = numPointsPerFrame;
    }

    @Override
    public void execute() {
        int numX = this.intensities.length;
        int numY = this.intensities[0].length;
        double[][] processedIntensities = new double[numX][numY];
        for (int i = 0; i < numX; ++i) {
            double[] tmpArray = new double[numY];
            System.arraycopy(this.intensities[i], 0, tmpArray, 0, numY);
            ArrayRankDouble arrayRankDouble = new ArrayRankDouble();
            double passValue = arrayRankDouble.getNthOrderedValue(tmpArray, this.numPointsPerFrame, false);
            for (int j = 0; j < numY; ++j) {
                if (!(this.intensities[i][j] >= passValue)) continue;
                processedIntensities[i][j] = this.intensities[i][j];
            }
        }
        this.intensities = processedIntensities;
    }

    @Override
    public double[][] getIntensities() {
        return this.intensities;
    }
}

