/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class AbstractProcessRunnable
implements Runnable {
    protected BlockingQueue<Process> m_Queue = new ArrayBlockingQueue<Process>(1);
    protected Process m_Process = null;
    protected boolean m_Stopped = false;

    public void stopExecution() {
        this.m_Stopped = true;
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public void setProcess(Process value) {
        this.m_Queue.add(value);
    }

    public Process getProcess() {
        return this.m_Process;
    }

    protected abstract void doRun();

    @Override
    public void run() {
        try {
            while (this.m_Process == null && !this.isStopped()) {
                try {
                    this.m_Process = this.m_Queue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {}
            }
            if (this.isStopped()) {
                return;
            }
            this.doRun();
        }
        catch (Exception e) {
            System.err.println("Failed to process #" + this.m_Process.hashCode() + ":");
            e.printStackTrace();
        }
    }
}

