/*
 * Decompiled with CFR 0.152.
 */
package auto.parcel.processor;

import auto.parcel.AutoParcel;
import auto.parcel.processor.EclipseHack;
import auto.parcel.processor.Template;
import auto.parcel.processor.TypeSimplifier;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedOptions(value={"auto.parcel.EclipseHackTest"})
@AutoService(value=Processor.class)
public class AutoParcelProcessor
extends AbstractProcessor {
    private static final boolean SILENT = true;
    private static final String TEMPLATE_STRING = AutoParcelProcessor.concatLines("$[pkg?package $[pkg];\n]", "$[imports:i||import $[i];\n]", "final class $[subclass]$[formaltypes] extends $[origclass]$[actualtypes] {", "$[props:p||  private final $[p.type] $[p];\n]", "  $[subclass](\n      $[props:p|,\n      |$[p.type] $[p]]) {", "$[props:p|\n|$[p.primitive!$[p.nullable!    if ($[p] == null) {", "      throw new NullPointerException(\"Null $[p]\");", "    }", "]]    this.$[p] = $[p];]", "  }", "$[props:p|\n|\n  @Override", "  $[p.access]$[p.type] $[p]() {", "    return $[p.array?[$[p.nullable?$[p] == null ? null : ]$[p].clone()][$[p]]];", "  }]", "$[toString?\n  @Override", "  public String toString() {", "    return \"$[simpleclassname]{\"$[props?\n        + \"]$[props:p|\n        + \", |$[p]=\" + $[p.array?[$[Arrays].toString($[p])][$[p]]]]", "        + \"}\";", "  }]", "$[equals?\n  @Override", "  public boolean equals(Object o) {", "    if (o == this) {", "      return true;", "    }", "    if (o instanceof $[origclass]) {", "      $[origclass]$[wildcardtypes] that = ($[origclass]$[wildcardtypes]) o;", "      return $[props!true]$[props:p|\n          && |($[p.equalsThatExpression])];", "    }", "    return false;", "  }]", "$[hashCode?", "$[cacheHashCode?  private transient int hashCode;\n\n]  @Override", "  public int hashCode() {", "$[cacheHashCode?    if (hashCode != 0) {", "      return hashCode;", "    }\n]    int h = 1;", "$[props:p||    h *= 1000003;", "    h ^= $[p.hashCodeExpression];", "]$[cacheHashCode?    hashCode = h;\n]    return h;", "  }]$[serialVersionUID?\n\n  private static final long serialVersionUID = $[serialVersionUID];]", "$[parcelable?\n\n", "  public static final android.os.Parcelable.Creator<$[origclass]> CREATOR = new android.os.Parcelable.Creator<$[origclass]>() {", "    @Override public $[origclass] createFromParcel(android.os.Parcel in) {", "      return new $[subclass](in);", "    }", "    @Override public $[origclass][] newArray(int size) {", "      return new $[origclass][size];", "    }", "  };", "", "  private final static java.lang.ClassLoader CL = $[subclass].class.getClassLoader();", "", "  private $[subclass](android.os.Parcel in) {", "    this(\n      $[props:p|,\n      |($[p.castType]) in.readValue(CL)]);", "  }", "", "  @Override public void writeToParcel(android.os.Parcel dest, int flags) {", "$[props:p||    dest.writeValue($[p]);\n]", "  }", "", "  @Override public int describeContents() {", "    return 0;", "  }", "]", "}");
    private static final Template template = Template.compile(TEMPLATE_STRING);

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(AutoParcel.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void note(String msg) {
    }

    private void reportError(String msg, Element e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    private void abortWithError(String msg, Element e) throws CompileException {
        this.reportError(msg, e);
        throw new CompileException();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean claimed;
        boolean bl = claimed = annotations.size() == 1 && annotations.iterator().next().getQualifiedName().toString().equals(AutoParcel.class.getName());
        if (claimed) {
            this.process(roundEnv);
            return true;
        }
        return false;
    }

    private void process(RoundEnvironment roundEnv) {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(AutoParcel.class);
        List<TypeElement> types = ElementFilter.typesIn(annotatedElements);
        for (TypeElement type : types) {
            try {
                this.processType(type);
            }
            catch (CompileException e) {
            }
            catch (RuntimeException e) {
                this.reportError("@AutoParcel processor threw an exception: " + e, type);
            }
        }
    }

    private String generatedClassName(TypeElement type, String prefix) {
        String name = type.getSimpleName().toString();
        while (type.getEnclosingElement() instanceof TypeElement) {
            type = (TypeElement)type.getEnclosingElement();
            name = type.getSimpleName() + "_" + name;
        }
        String pkg = TypeSimplifier.packageNameOf(type);
        String dot = pkg.isEmpty() ? "" : ".";
        return pkg + dot + prefix + name;
    }

    private String generatedSubclassName(TypeElement type) {
        return this.generatedClassName(type, "AutoParcel_");
    }

    private static String simpleNameOf(String s) {
        if (s.contains(".")) {
            return s.substring(s.lastIndexOf(46) + 1);
        }
        return s;
    }

    private static String classNameOf(TypeElement type) {
        String name = type.getQualifiedName().toString();
        String pkgName = TypeSimplifier.packageNameOf(type);
        if (!pkgName.isEmpty()) {
            return name.substring(pkgName.length() + 1);
        }
        return name;
    }

    private static String concatLines(String ... lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    private static boolean isJavaLangObject(TypeElement type) {
        return type.getSuperclass().getKind() == TypeKind.NONE && type.getKind() == ElementKind.CLASS;
    }

    private static boolean isToStringOrEqualsOrHashCode(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return (name.equals("toString") || name.equals("hashCode")) && method.getParameters().isEmpty() || name.equals("equals") && method.getParameters().size() == 1 && method.getParameters().get(0).asType().toString().equals("java.lang.Object");
    }

    private void findLocalAndInheritedMethods(TypeElement type, List<ExecutableElement> methods) {
        this.note("Looking at methods in " + type);
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (TypeMirror typeMirror : type.getInterfaces()) {
            this.findLocalAndInheritedMethods((TypeElement)typeUtils.asElement(typeMirror), methods);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            this.findLocalAndInheritedMethods((TypeElement)typeUtils.asElement(type.getSuperclass()), methods);
        }
        List<ExecutableElement> theseMethods = ElementFilter.methodsIn(type.getEnclosedElements());
        this.eclipseHack().sortMethodsIfSimulatingEclipse(theseMethods);
        for (ExecutableElement method : theseMethods) {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            boolean alreadySeen = false;
            Iterator<ExecutableElement> methodIter = methods.iterator();
            while (methodIter.hasNext()) {
                ExecutableElement otherMethod = methodIter.next();
                if (elementUtils.overrides(method, otherMethod, type)) {
                    methodIter.remove();
                    continue;
                }
                if (!method.getSimpleName().equals(otherMethod.getSimpleName()) || !method.getParameters().equals(otherMethod.getParameters())) continue;
                alreadySeen = true;
            }
            if (alreadySeen) continue;
            methods.add(method);
        }
    }

    private void processType(TypeElement type) throws CompileException {
        AutoParcel autoParcel = type.getAnnotation(AutoParcel.class);
        if (autoParcel == null) {
            this.abortWithError("annotation processor for @AutoParcel was invoked with a type that does not have that annotation; this is probably a compiler bug", type);
        }
        if (type.getKind() != ElementKind.CLASS) {
            this.abortWithError("@" + AutoParcel.class.getName() + " only applies to classes", type);
        }
        if (this.ancestorIsAndroidAutoParcel(type)) {
            this.abortWithError("One @AutoParcel class may not extend another", type);
        }
        TreeMap<String, Object> vars = new TreeMap<String, Object>();
        vars.put("pkg", TypeSimplifier.packageNameOf(type));
        vars.put("origclass", AutoParcelProcessor.classNameOf(type));
        vars.put("simpleclassname", AutoParcelProcessor.simpleNameOf(AutoParcelProcessor.classNameOf(type)));
        vars.put("formaltypes", AutoParcelProcessor.formalTypeString(type));
        vars.put("actualtypes", AutoParcelProcessor.actualTypeString(type));
        vars.put("wildcardtypes", AutoParcelProcessor.wildcardTypeString(type));
        vars.put("subclass", AutoParcelProcessor.simpleNameOf(this.generatedSubclassName(type)));
        vars.put("cacheHashCode", autoParcel.cacheHashCode());
        this.defineVarsForType(type, vars);
        String text = template.rewrite(vars);
        this.writeSourceFile(this.generatedSubclassName(type), text, type);
    }

    private void defineVarsForType(TypeElement type, Map<String, Object> vars) throws CompileException {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        this.findLocalAndInheritedMethods(type, methods);
        vars.putAll(AutoParcelProcessor.objectMethodsToGenerate(methods));
        this.dontImplementAnnotationEqualsOrHashCode(type, vars);
        List<ExecutableElement> toImplement = this.methodsToImplement(methods);
        HashSet<TypeMirror> types = new HashSet<TypeMirror>();
        types.addAll(this.returnTypesOf(toImplement));
        TypeMirror javaUtilArrays = this.getTypeMirror(Arrays.class);
        if (AutoParcelProcessor.containsArrayType(types)) {
            types.add(javaUtilArrays);
        }
        String pkg = TypeSimplifier.packageNameOf(type);
        TypeSimplifier typeSimplifier = new TypeSimplifier(this.processingEnv.getTypeUtils(), pkg, types);
        vars.put("imports", typeSimplifier.typesToImport());
        vars.put("Arrays", typeSimplifier.simplify(javaUtilArrays));
        ArrayList<Property> props = new ArrayList<Property>();
        for (ExecutableElement method : toImplement) {
            String propType = typeSimplifier.simplify(method.getReturnType());
            Property prop = new Property(method, propType, vars);
            props.add(prop);
        }
        this.eclipseHack().reorderProperties(props);
        vars.put("props", props);
        vars.put("serialVersionUID", this.getSerialVersionUID(type));
        TypeMirror parcelable = this.getTypeMirror("android.os.Parcelable");
        vars.put("parcelable", this.processingEnv.getTypeUtils().isAssignable(type.asType(), parcelable));
    }

    private Set<TypeMirror> returnTypesOf(List<ExecutableElement> methods) {
        HashSet<TypeMirror> returnTypes = new HashSet<TypeMirror>();
        for (ExecutableElement method : methods) {
            returnTypes.add(method.getReturnType());
        }
        return returnTypes;
    }

    private static boolean containsArrayType(Set<TypeMirror> types) {
        for (TypeMirror type : types) {
            if (type.getKind() != TypeKind.ARRAY) continue;
            return true;
        }
        return false;
    }

    private void dontImplementAnnotationEqualsOrHashCode(TypeElement type, Map<String, ?> vars) {
        TypeMirror javaLangAnnotationAnnotation = this.getTypeMirror(Annotation.class);
        Types typeUtils = this.processingEnv.getTypeUtils();
        if (typeUtils.isAssignable(type.asType(), javaLangAnnotationAnnotation)) {
            boolean equals = (Boolean)vars.get("equals");
            boolean hashCode = (Boolean)vars.get("hashCode");
            if (equals || hashCode) {
                String bad = equals ? (hashCode ? "equals(Object) and hashCode()" : "equals(Object)") : "hashCode()";
                this.reportError("The implementation of " + bad + " that would be generated for this @AutoParcel " + "class would not obey the contract of " + bad + " in " + Annotation.class.getName(), type);
            }
        }
    }

    private static Map<String, Boolean> objectMethodsToGenerate(List<ExecutableElement> methods) {
        TreeMap<String, Boolean> vars = new TreeMap<String, Boolean>();
        vars.put("equals", false);
        vars.put("hashCode", false);
        vars.put("toString", false);
        for (ExecutableElement method : methods) {
            if (!AutoParcelProcessor.isToStringOrEqualsOrHashCode(method)) continue;
            boolean canGenerate = method.getModifiers().contains((Object)Modifier.ABSTRACT) || AutoParcelProcessor.isJavaLangObject((TypeElement)method.getEnclosingElement());
            vars.put(method.getSimpleName().toString(), canGenerate);
        }
        assert (vars.size() == 3);
        return vars;
    }

    private List<ExecutableElement> methodsToImplement(List<ExecutableElement> methods) throws CompileException {
        ArrayList<ExecutableElement> toImplement = new ArrayList<ExecutableElement>();
        boolean errors = false;
        for (ExecutableElement method : methods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT) || AutoParcelProcessor.isToStringOrEqualsOrHashCode(method) || this.isFromParcelable(method)) continue;
            if (method.getParameters().isEmpty() && method.getReturnType().getKind() != TypeKind.VOID) {
                if (AutoParcelProcessor.isReferenceArrayType(method.getReturnType())) {
                    this.reportError("An @AutoParcel class cannot define an array-valued property unless it is a primitive array", method);
                    errors = true;
                }
                toImplement.add(method);
                continue;
            }
            this.reportError("@AutoParcel classes cannot have abstract methods other than property getters", method);
            errors = true;
        }
        if (errors) {
            throw new CompileException();
        }
        return toImplement;
    }

    private boolean isFromParcelable(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        boolean isDescribeContents = name.equals("describeContents") && method.getParameters().isEmpty() && method.getReturnType().toString().equals("int");
        boolean isWriteToParcel = name.equals("writeToParcel") && method.getParameters().size() == 2 && method.getReturnType().toString().equals("void") && method.getParameters().get(0).asType().toString().equals("android.os.Parcel") && method.getParameters().get(1).asType().toString().equals("int");
        return isDescribeContents || isWriteToParcel;
    }

    private static boolean isReferenceArrayType(TypeMirror type) {
        return type.getKind() == TypeKind.ARRAY && !((ArrayType)type).getComponentType().getKind().isPrimitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSourceFile(String className, String text, TypeElement originatingType) {
        try {
            this.note(text);
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(className, originatingType);
            Writer writer = sourceFile.openWriter();
            try {
                writer.write(text);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not write generated class " + className + ": " + e);
        }
    }

    private boolean ancestorIsAndroidAutoParcel(TypeElement type) {
        TypeMirror parentMirror;
        while ((parentMirror = type.getSuperclass()).getKind() != TypeKind.NONE) {
            Types typeUtils = this.processingEnv.getTypeUtils();
            TypeElement parentElement = (TypeElement)typeUtils.asElement(parentMirror);
            if (parentElement.getAnnotation(AutoParcel.class) != null) {
                return true;
            }
            type = parentElement;
        }
        return false;
    }

    private String getSerialVersionUID(TypeElement type) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror serializable = this.getTypeMirror(Serializable.class);
        if (typeUtils.isAssignable(type.asType(), serializable)) {
            List<VariableElement> fields = ElementFilter.fieldsIn(type.getEnclosedElements());
            for (VariableElement field : fields) {
                if (!field.getSimpleName().toString().equals("serialVersionUID")) continue;
                Object value = field.getConstantValue();
                if (field.getModifiers().containsAll(Arrays.asList(Modifier.STATIC, Modifier.FINAL)) && field.asType().getKind() == TypeKind.LONG && value != null) {
                    return value + "L";
                }
                this.reportError("serialVersionUID must be a static final long compile-time constant", field);
                break;
            }
        }
        return "";
    }

    private TypeMirror getTypeMirror(Class<?> c) {
        return this.getTypeMirror(c.getName());
    }

    private TypeMirror getTypeMirror(String className) {
        return this.processingEnv.getElementUtils().getTypeElement(className).asType();
    }

    private static String typeParameterString(TypeParameterElement type) {
        String s = type.getSimpleName().toString();
        List<? extends TypeMirror> bounds = type.getBounds();
        if (bounds.isEmpty()) {
            return s;
        }
        s = s + " extends ";
        String sep = "";
        for (TypeMirror typeMirror : bounds) {
            s = s + sep + typeMirror;
            sep = " & ";
        }
        return s;
    }

    private static String formalTypeString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        String s = "<";
        String sep = "";
        for (TypeParameterElement typeParameterElement : typeParameters) {
            s = s + sep + AutoParcelProcessor.typeParameterString(typeParameterElement);
            sep = ", ";
        }
        return s + ">";
    }

    private static String actualTypeString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        String s = "<";
        String sep = "";
        for (TypeParameterElement typeParameterElement : typeParameters) {
            s = s + sep + typeParameterElement.getSimpleName();
            sep = ", ";
        }
        return s + ">";
    }

    private static String wildcardTypeString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        String s = "<";
        String sep = "";
        for (int i = 0; i < typeParameters.size(); ++i) {
            s = s + sep + "?";
            sep = ", ";
        }
        return s + ">";
    }

    private EclipseHack eclipseHack() {
        return new EclipseHack(this.processingEnv);
    }

    static class Property {
        private final ExecutableElement method;
        private final String type;
        private final Map<String, Object> vars;
        private static final Template PRIMITIVE_EQUALS_TEMPLATE = Template.compile("this.$[p] == that.$[p]()");
        private static final Template ARRAY_EQUALS_TEMPLATE = Template.compile("$[Arrays].equals(this.$[p], (that instanceof $[subclass]) ? (($[subclass]) that).$[p] : that.$[p]())");
        private static final Template FLOAT_EQUALS_TEMPLATE = Template.compile("Float.floatToIntBits(this.$[p]) == Float.floatToIntBits(that.$[p]())");
        private static final Template DOUBLE_EQUALS_TEMPLATE = Template.compile("Double.doubleToLongBits(this.$[p]) == Double.doubleToLongBits(that.$[p]())");
        private static final Template OBJECT_EQUALS_TEMPLATE = Template.compile("$[p.nullable?(this.$[p] == null) ? (that.$[p]() == null) : ]this.$[p].equals(that.$[p]())");

        Property(ExecutableElement method, String type, Map<String, Object> vars) {
            this.method = method;
            this.type = type;
            this.vars = vars;
        }

        public String toString() {
            return this.method.getSimpleName().toString();
        }

        TypeElement owner() {
            return (TypeElement)this.method.getEnclosingElement();
        }

        public String type() {
            return this.type;
        }

        public String castType() {
            return this.primitive() ? this.box(this.method.getReturnType().getKind()) : this.type();
        }

        private String box(TypeKind kind) {
            switch (kind) {
                case BOOLEAN: {
                    return "Boolean";
                }
                case BYTE: {
                    return "Byte";
                }
                case SHORT: {
                    return "Short";
                }
                case INT: {
                    return "Integer";
                }
                case LONG: {
                    return "Long";
                }
                case CHAR: {
                    return "Character";
                }
                case FLOAT: {
                    return "Float";
                }
                case DOUBLE: {
                    return "Double";
                }
            }
            throw new RuntimeException("Found a new Primitive type on the Java platform. Go ahead and claim " + (Object)((Object)kind) + " yours");
        }

        public boolean primitive() {
            return this.method.getReturnType().getKind().isPrimitive();
        }

        public boolean array() {
            return this.method.getReturnType().getKind() == TypeKind.ARRAY;
        }

        public boolean nullable() {
            for (AnnotationMirror annotationMirror : this.method.getAnnotationMirrors()) {
                String name = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
                if (!name.equals("Nullable")) continue;
                return true;
            }
            return false;
        }

        public String equalsThatExpression() {
            Template template;
            switch (this.method.getReturnType().getKind()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case CHAR: {
                    template = PRIMITIVE_EQUALS_TEMPLATE;
                    break;
                }
                case FLOAT: {
                    template = FLOAT_EQUALS_TEMPLATE;
                    break;
                }
                case DOUBLE: {
                    template = DOUBLE_EQUALS_TEMPLATE;
                    break;
                }
                case ARRAY: {
                    template = ARRAY_EQUALS_TEMPLATE;
                    break;
                }
                default: {
                    template = OBJECT_EQUALS_TEMPLATE;
                }
            }
            TreeMap<String, Object> newVars = new TreeMap<String, Object>(this.vars);
            newVars.put("p", this);
            return template.rewrite(newVars);
        }

        public String hashCodeExpression() {
            switch (this.method.getReturnType().getKind()) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case CHAR: {
                    return this.toString();
                }
                case LONG: {
                    return "(" + this + " >>> 32) ^ " + this;
                }
                case FLOAT: {
                    return "Float.floatToIntBits(" + this + ")";
                }
                case DOUBLE: {
                    return "(Double.doubleToLongBits(" + this + ") >>> 32) ^ " + "Double.doubleToLongBits(" + this + ")";
                }
                case BOOLEAN: {
                    return this + " ? 1231 : 1237";
                }
                case ARRAY: {
                    return this.vars.get("Arrays") + ".hashCode(" + this + ")";
                }
            }
            if (this.nullable()) {
                return "(" + this + " == null) ? 0 : " + this + ".hashCode()";
            }
            return this + ".hashCode()";
        }

        public String access() {
            Set<Modifier> mods = this.method.getModifiers();
            if (mods.contains((Object)Modifier.PUBLIC)) {
                return "public ";
            }
            if (mods.contains((Object)Modifier.PROTECTED)) {
                return "protected ";
            }
            return "";
        }
    }

    private static class CompileException
    extends Exception {
        private CompileException() {
        }
    }
}

