/*
 * Decompiled with CFR 0.152.
 */
package auto.parcel.processor;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class AbstractMethodLister {
    private final InputStream inputStream;

    AbstractMethodLister(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    ImmutableList<String> abstractNoArgMethods() {
        try {
            return this.abstractNoArgMethodsX();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ImmutableList<String> abstractNoArgMethodsX() throws IOException {
        ClassReader classReader = new ClassReader(this.inputStream);
        RecordingClassVisitor classVisitor = new RecordingClassVisitor();
        classReader.accept((ClassVisitor)classVisitor, 0);
        return classVisitor.abstractNoArgMethods.build();
    }

    private static class RecordingClassVisitor
    extends ClassVisitor {
        private final ImmutableList.Builder<String> abstractNoArgMethods = ImmutableList.builder();

        RecordingClassVisitor() {
            super(262144);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Modifier.isAbstract(access) && desc.contains("()") && !desc.endsWith("V")) {
                this.abstractNoArgMethods.add((Object)name);
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

