/*
 * Decompiled with CFR 0.152.
 */
package auto.parcel.processor;

import auto.parcel.AutoParcel;
import com.google.auto.common.MoreElements;
import com.google.auto.common.SuperficialValidation;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public class AutoParcelBuilderProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoParcel.Builder.class.getCanonicalName(), (Object)AutoParcel.Validate.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> builderTypes = roundEnv.getElementsAnnotatedWith(AutoParcel.Builder.class);
        if (!SuperficialValidation.validateElements(builderTypes)) {
            return false;
        }
        for (Element element : builderTypes) {
            if (!MoreElements.isAnnotationPresent((Element)element, AutoParcel.Builder.class)) continue;
            this.validate(element, "@AutoParcel.Builder can only be applied to a class or interface inside an @AutoParcel class");
        }
        Set<? extends Element> validateMethods = roundEnv.getElementsAnnotatedWith(AutoParcel.Validate.class);
        if (!SuperficialValidation.validateElements(validateMethods)) {
            return false;
        }
        for (Element element : validateMethods) {
            if (!MoreElements.isAnnotationPresent((Element)element, AutoParcel.Validate.class)) continue;
            this.validate(element, "@AutoParcel.Validate can only be applied to a method inside an @AutoParcel class");
        }
        return false;
    }

    private void validate(Element annotatedType, String errorMessage) {
        Element container = annotatedType.getEnclosingElement();
        if (!MoreElements.isAnnotationPresent((Element)container, AutoParcel.class)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage, annotatedType);
        }
    }
}

