/*
 * Decompiled with CFR 0.152.
 */
package auto.parcel.processor;

import auto.parcel.processor.AbstractMethodExtractor;
import auto.parcel.processor.AbstractMethodLister;
import auto.parcel.processor.AutoParcelProcessor;
import auto.parcel.processor.JavaTokenizer;
import auto.parcel.processor.TypeSimplifier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

class EclipseHack {
    private final ProcessingEnvironment processingEnv;

    EclipseHack(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    void reorderProperties(List<AutoParcelProcessor.Property> properties) {
        int index = 0;
        while (index < properties.size()) {
            int nextIndex;
            TypeElement owner = properties.get(index).getOwner();
            for (nextIndex = index + 1; nextIndex < properties.size() && properties.get(nextIndex).getOwner().equals(owner); ++nextIndex) {
            }
            List<AutoParcelProcessor.Property> subList = properties.subList(index, nextIndex);
            this.reorderProperties(owner, subList);
            index = nextIndex;
        }
    }

    private void reorderProperties(TypeElement type, List<AutoParcelProcessor.Property> properties) {
        ImmutableList<String> order;
        PropertyOrderer propertyOrderer = this.getPropertyOrderer(type);
        if (propertyOrderer == null) {
            return;
        }
        try {
            order = propertyOrderer.determinePropertyOrder();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, e.toString());
            return;
        }
        boolean allFound = true;
        for (AutoParcelProcessor.Property property : properties) {
            allFound &= order.contains((Object)property.getGetter());
        }
        if (allFound) {
            Comparator<AutoParcelProcessor.Property> comparator = new Comparator<AutoParcelProcessor.Property>(){

                @Override
                public int compare(AutoParcelProcessor.Property a, AutoParcelProcessor.Property b) {
                    String aName = a.getGetter();
                    String bName = b.getGetter();
                    return order.indexOf((Object)aName) - order.indexOf((Object)bName);
                }
            };
            Collections.sort(properties, comparator);
        }
    }

    private PropertyOrderer getPropertyOrderer(TypeElement type) {
        try {
            Method getEnclosingIFile = this.processingEnv.getClass().getMethod("getEnclosingIFile", Element.class);
            final Object iFile = getEnclosingIFile.invoke((Object)this.processingEnv, type);
            URI uri = (URI)iFile.getClass().getMethod("getRawLocationURI", new Class[0]).invoke(iFile, new Object[0]);
            if (uri.getPath().endsWith(".class")) {
                return new BinaryPropertyOrderer(uri);
            }
            Method getCharset = iFile.getClass().getMethod("getCharset", new Class[0]);
            final String charset = (String)getCharset.invoke(iFile, new Object[0]);
            final Method getContents = iFile.getClass().getMethod("getContents", new Class[0]);
            Callable<Reader> readerProvider = new Callable<Reader>(){

                @Override
                public Reader call() throws Exception {
                    InputStream inputStream = (InputStream)getContents.invoke(iFile, new Object[0]);
                    return new InputStreamReader(inputStream, charset);
                }
            };
            return new SourcePropertyOrderer(type, readerProvider);
        }
        catch (Exception e) {
            if (!type.getClass().getName().toLowerCase().contains("eclipse")) {
                return null;
            }
            try {
                final String filename = (String)type.getClass().getMethod("getFileName", new Class[0]).invoke((Object)type, new Object[0]);
                Callable<Reader> readerProvider = new Callable<Reader>(){

                    @Override
                    public Reader call() throws Exception {
                        return new FileReader(filename);
                    }
                };
                return new SourcePropertyOrderer(type, readerProvider);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    private class BinaryPropertyOrderer
    implements PropertyOrderer {
        private final URI classFileUri;

        BinaryPropertyOrderer(URI classFileUri) {
            this.classFileUri = classFileUri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImmutableList<String> determinePropertyOrder() throws IOException {
            InputStream inputStream = null;
            try {
                URL classFileUrl = this.classFileUri.toURL();
                inputStream = classFileUrl.openStream();
                AbstractMethodLister lister = new AbstractMethodLister(inputStream);
                ImmutableList<String> immutableList = lister.abstractNoArgMethods();
                return immutableList;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private class SourcePropertyOrderer
    implements PropertyOrderer {
        private final TypeElement type;
        private final Callable<Reader> readerProvider;

        SourcePropertyOrderer(TypeElement type, Callable<Reader> readerProvider) {
            this.type = type;
            this.readerProvider = readerProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImmutableList<String> determinePropertyOrder() throws IOException {
            Reader sourceReader;
            try {
                sourceReader = this.readerProvider.call();
            }
            catch (Exception e) {
                return ImmutableList.of();
            }
            try {
                String packageName = TypeSimplifier.packageNameOf(this.type);
                String className = this.type.getQualifiedName().toString();
                AbstractMethodExtractor extractor = new AbstractMethodExtractor();
                JavaTokenizer tokenizer = new JavaTokenizer(sourceReader);
                ImmutableListMultimap<String, String> methodOrders = extractor.abstractMethods(tokenizer, packageName);
                ImmutableList immutableList = methodOrders.get((Object)className);
                return immutableList;
            }
            finally {
                sourceReader.close();
            }
        }
    }

    private static interface PropertyOrderer {
        public ImmutableList<String> determinePropertyOrder() throws IOException;
    }
}

