/*
 * Decompiled with CFR 0.152.
 */
package auto.parcel.processor;

import auto.parcel.processor.AutoParcelProcessor;
import auto.parcel.processor.AutoParcelTemplateVars;
import auto.parcel.processor.GwtCompatibility;
import auto.parcel.processor.TemplateVars;
import auto.parcel.processor.TypeMirrorSet;
import auto.parcel.processor.TypeSimplifier;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.zip.CRC32;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.velocity.runtime.parser.node.SimpleNode;

class GwtSerialization {
    private final GwtCompatibility gwtCompatibility;
    private final ProcessingEnvironment processingEnv;
    private final TypeElement type;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    GwtSerialization(GwtCompatibility gwtCompatibility, ProcessingEnvironment processingEnv, TypeElement type) {
        this.gwtCompatibility = gwtCompatibility;
        this.processingEnv = processingEnv;
        this.type = type;
    }

    private boolean shouldWriteGwtSerializer() {
        Optional<AnnotationMirror> optionalGwtCompatible = this.gwtCompatibility.gwtCompatibleAnnotation();
        if (optionalGwtCompatible.isPresent()) {
            AnnotationMirror gwtCompatible = (AnnotationMirror)optionalGwtCompatible.get();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : Collections.unmodifiableMap(gwtCompatible.getElementValues()).entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals("serializable") || !entry.getValue().getValue().equals(true)) continue;
                return true;
            }
        }
        return false;
    }

    void maybeWriteGwtSerializer(AutoParcelTemplateVars autoVars) {
        if (this.shouldWriteGwtSerializer()) {
            GwtTemplateVars vars = new GwtTemplateVars();
            vars.imports = autoVars.imports;
            vars.pkg = autoVars.pkg;
            vars.subclass = autoVars.subclass;
            String className = (vars.pkg.isEmpty() ? "" : vars.pkg + ".") + vars.subclass + "_CustomFieldSerializer";
            vars.serializerClass = TypeSimplifier.simpleNameOf(className);
            vars.props = new ArrayList<Property>();
            for (AutoParcelProcessor.Property prop : autoVars.props) {
                vars.props.add(new Property(prop));
            }
            vars.classHashString = this.computeClassHash(autoVars.props);
            String text = vars.toText();
            this.writeSourceFile(className, text, this.type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSourceFile(String className, String text, TypeElement originatingType) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(className, originatingType);
            Writer writer = sourceFile.openWriter();
            try {
                writer.write(text);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not write generated class " + className + ": " + e);
        }
    }

    private String computeClassHash(List<AutoParcelProcessor.Property> props) {
        TypeSimplifier typeSimplifier = new TypeSimplifier(this.processingEnv.getTypeUtils(), "", new TypeMirrorSet(), null);
        CRC32 crc = new CRC32();
        GwtSerialization.update(crc, typeSimplifier.simplify(this.type.asType()) + ":");
        for (AutoParcelProcessor.Property prop : props) {
            GwtSerialization.update(crc, prop.toString() + ":" + prop.getType() + ";");
        }
        return String.format("%08x", crc.getValue());
    }

    private static void update(CRC32 crc, String s) {
        crc.update(s.getBytes(UTF8));
    }

    static class GwtTemplateVars
    extends TemplateVars {
        List<Property> props;
        SortedSet<String> imports;
        String pkg;
        String subclass;
        String serializerClass;
        String classHashString;
        private static final SimpleNode TEMPLATE = GwtTemplateVars.parsedTemplateForResource("gwtserializer.vm");

        GwtTemplateVars() {
        }

        @Override
        SimpleNode parsedTemplate() {
            return TEMPLATE;
        }
    }

    public static class Property {
        private final AutoParcelProcessor.Property property;
        private final boolean isCastingUnchecked;

        Property(AutoParcelProcessor.Property property) {
            this.property = property;
            this.isCastingUnchecked = TypeSimplifier.isCastingUnchecked(property.getTypeMirror());
        }

        public String toString() {
            return this.property.toString();
        }

        public String getGetter() {
            return this.property.getGetter();
        }

        public String getType() {
            return this.property.getType();
        }

        public String getGwtType() {
            String type = this.property.getType();
            if (this.property.getKind().isPrimitive()) {
                return Character.toUpperCase(type.charAt(0)) + type.substring(1);
            }
            if (type.equals("String")) {
                return "String";
            }
            return "Object";
        }

        public String getGwtCast() {
            if (this.property.getKind().isPrimitive() || this.getType().equals("String")) {
                return "";
            }
            return "(" + this.getType() + ") ";
        }

        public boolean isCastingUnchecked() {
            return this.isCastingUnchecked;
        }
    }
}

