/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel;

import com.geese.plugin.excel.OperationKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class ExcelHelper {
    private static ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
    private static Pattern likePattern = Pattern.compile("\\s*[^\\s]+\\s+(not)?like\\s+[^\\s)]+");
    private static Pattern inPattern = Pattern.compile("\\s*[^\\s]+\\s+(not)?in\\s+[^\\s)]+");
    private static String[] queryKeys = new String[]{OperationKey.FROM.name(), OperationKey.WHERE.name(), OperationKey.LIMIT.name()};
    private static String[] insertKeys = new String[]{OperationKey.INTO.name(), OperationKey.LIMIT.name()};

    public static boolean isXls(InputStream input) {
        try {
            new XSSFWorkbook(input);
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public static boolean isXlsx(InputStream input) {
        return !ExcelHelper.isXls(input);
    }

    public static Object getCellValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 2: {
                return cell.getNumericCellValue();
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    public static Cell setCellValue(Cell cell, Object value) {
        if (null == cell || null == value) {
            return cell;
        }
        Class<?> valueClass = value.getClass();
        if (String.class.isAssignableFrom(valueClass)) {
            cell.setCellValue((String)value);
            return cell;
        }
        if (Boolean.class.isAssignableFrom(valueClass)) {
            cell.setCellValue(((Boolean)value).booleanValue());
            return cell;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            cell.setCellValue((Date)value);
            return cell;
        }
        if (Calendar.class.isAssignableFrom(valueClass)) {
            cell.setCellValue((Calendar)value);
            return cell;
        }
        if (Double.class.isAssignableFrom(valueClass)) {
            cell.setCellValue(((Double)value).doubleValue());
            return cell;
        }
        if (RichTextString.class.isAssignableFrom(valueClass)) {
            cell.setCellValue((RichTextString)value);
            return cell;
        }
        cell.setCellValue(value.toString());
        return cell;
    }

    public static Cell createCell(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (null != cell) {
            return cell;
        }
        return row.createCell(cellIndex);
    }

    public static Row createRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (null != row) {
            return row;
        }
        return sheet.createRow(rowIndex);
    }

    public static boolean whereFilter(String where, Map conditionMap, Map parameterMap) {
        boolean hasParameter = where.contains(":") || where.contains("?");
        Bindings bindings = engine.createBindings();
        String parsedWhere = where;
        if (hasParameter) {
            parsedWhere = ExcelHelper.bindVariableToParameterizedScript(where, parameterMap, bindings);
        }
        bindings.putAll(conditionMap);
        parsedWhere = ExcelHelper.symbolEscape(parsedWhere);
        parsedWhere = ExcelHelper.likeOperationParse(parsedWhere, bindings);
        parsedWhere = ExcelHelper.inOperationParse(parsedWhere, bindings);
        try {
            System.out.println("\u89e3\u6790\u540e\u7684where:" + parsedWhere + ", \u7ed1\u5b9a\u7684\u53c2\u6570\uff1a" + new LinkedHashMap<String, Object>(bindings));
            return true == Boolean.valueOf(engine.eval(parsedWhere, bindings).toString());
        }
        catch (ScriptException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String bindVariableToParameterizedScript(String parameterizedScript, Map variableMap, Bindings bindings) {
        String script;
        block3: {
            String uuid;
            block2: {
                script = String.valueOf(parameterizedScript);
                uuid = "_" + UUID.randomUUID().toString().replace("-", "");
                if (!script.contains(":")) break block2;
                script = script.replaceAll("\\:", uuid);
                Set variableSet = variableMap.keySet();
                for (Object variable : variableSet) {
                    bindings.put(uuid + variable, variableMap.get(variable));
                }
                break block3;
            }
            if (!script.contains("?")) break block3;
            Collection values = variableMap.values();
            int index = 0;
            for (Object value : values) {
                String variable = uuid + "_" + index++;
                script = script.replaceFirst("\\?", variable);
                bindings.put(variable, value);
            }
        }
        return script;
    }

    private static String symbolEscape(String str) {
        String ref = String.valueOf(str);
        ref = ref.replaceAll("and\\s+", "&& ");
        ref = ref.replaceAll("and\\(", "&&(");
        ref = ref.replaceAll("or\\s+", "|| ");
        ref = ref.replaceAll("or\\(", "||(");
        return ref;
    }

    private static String likeOperationParse(String where, Map parameterMap) {
        String ref = String.valueOf(where);
        Matcher m = likePattern.matcher(ref);
        while (m.find()) {
            String matched = m.group().trim();
            String[] likeCondition = matched.split("\\s+");
            String variable = likeCondition[0];
            String operation = likeCondition[1];
            String parameterVariable = likeCondition[2];
            String parameterValue = parameterMap.get(parameterVariable).toString();
            if (!parameterValue.matches("\\/.+\\/.?")) {
                parameterValue = parameterValue.replaceAll("%", ".*").replaceAll("_", ".");
                parameterValue = "/^" + parameterValue + "$/i";
            }
            if (operation.startsWith("not")) {
                parameterValue = "!" + parameterValue;
            }
            String regex = parameterValue + ".test(" + variable + ")";
            ref = ref.replace(matched, regex);
        }
        return ref;
    }

    private static String inOperationParse(String where, Map parameterMap) {
        String ref = String.valueOf(where);
        Matcher m = inPattern.matcher(ref);
        while (m.find()) {
            String matched = m.group().trim();
            String[] likeCondition = matched.split("\\s+");
            String variable = likeCondition[0];
            String operation = likeCondition[1];
            String parameterVariable = likeCondition[2];
            Object parameterValue = parameterMap.get(parameterVariable);
            Iterator<Object> parameterValueIterator = Iterable.class.isAssignableFrom(parameterValue.getClass()) ? ((Iterable)parameterValue).iterator() : Arrays.asList(parameterValue).iterator();
            StringBuffer inValueRegex = new StringBuffer();
            while (parameterValueIterator.hasNext()) {
                inValueRegex.append("^" + parameterValueIterator.next() + "$|");
            }
            inValueRegex = inValueRegex.deleteCharAt(inValueRegex.length() - 1);
            String regex = "/" + inValueRegex.toString() + "/";
            if (operation.startsWith("not")) {
                regex = "!" + regex;
            }
            regex = regex + ".test(" + variable + ")";
            ref = ref.replace(matched, regex);
        }
        return ref;
    }

    public static Map<OperationKey, String> parseQuery(String query) {
        return ExcelHelper.parseKeys(query, queryKeys);
    }

    public static Map<OperationKey, String> parseInsert(String insert) {
        return ExcelHelper.parseKeys(insert, insertKeys);
    }

    private static Map<OperationKey, String> parseKeys(String query, String[] keys) {
        String matched;
        String parsedQuery = String.valueOf(query).replaceAll("\\s+", " ");
        Pattern p = Pattern.compile("`[^`]+`");
        Matcher m = p.matcher(parsedQuery);
        while (m.find()) {
            matched = m.group();
            parsedQuery = parsedQuery.replace(matched, matched.toUpperCase());
        }
        ArrayList<String> usedKeys = new ArrayList<String>();
        for (String key : keys) {
            String wrapKey = ExcelHelper.wrapKey(key);
            if (!parsedQuery.contains(wrapKey)) {
                p = Pattern.compile("\\s+" + key + "\\s+", 2);
                m = p.matcher(query);
                if (!m.find()) continue;
                matched = m.group();
                parsedQuery = parsedQuery.replace(matched, " " + wrapKey + " ");
                usedKeys.add(wrapKey);
                continue;
            }
            usedKeys.add(wrapKey);
        }
        LinkedHashMap<OperationKey, String> keyDataMap = new LinkedHashMap<OperationKey, String>();
        int nextKeyIndex = 0;
        int index = 0;
        for (String usedKey : usedKeys) {
            int keyIndex = parsedQuery.indexOf(usedKey);
            String keyData = parsedQuery.substring(nextKeyIndex, keyIndex).trim();
            keyDataMap.put(index == 0 ? OperationKey.COLUMN : OperationKey.valueOf(ExcelHelper.unWrapKey((String)usedKeys.get(index - 1))), keyData);
            nextKeyIndex = keyIndex + usedKey.length();
            ++index;
        }
        keyDataMap.put(OperationKey.valueOf(ExcelHelper.unWrapKey((String)usedKeys.get(usedKeys.size() - 1))), parsedQuery.substring(nextKeyIndex).trim());
        return keyDataMap;
    }

    public static String wrapKey(String key) {
        return "`" + key + "`";
    }

    public static String unWrapKey(String key) {
        return key.replace("`", "");
    }

    public static boolean isNumber(String text) {
        return null != text && text.matches("([0-9])|([1-9][0-9]\\d*)");
    }

    public static Map<String, PictureData> getPictures(Sheet sheet) {
        if (sheet instanceof HSSFSheet) {
            return ExcelHelper.getSheetPictures((HSSFSheet)sheet);
        }
        return ExcelHelper.getXSheetPictures((XSSFSheet)sheet);
    }

    public static Map<Integer, PictureData> getPictures(Row row) {
        if (row instanceof HSSFRow) {
            return ExcelHelper.getSheetPictures((HSSFRow)row);
        }
        return ExcelHelper.getXSheetPictures((XSSFRow)row);
    }

    public static Picture setPicture(Cell cell, byte[] pictureData) {
        if (null == pictureData || pictureData.length <= 0) {
            return null;
        }
        Sheet sheet = cell.getSheet();
        Workbook workbook = sheet.getWorkbook();
        CreationHelper helper = workbook.getCreationHelper();
        int pictureIndex = workbook.addPicture(pictureData, 5);
        Drawing drawing = sheet.getDrawingPatriarch();
        if (null == drawing) {
            drawing = sheet.createDrawingPatriarch();
        }
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow1(cell.getRowIndex());
        Picture picture = drawing.createPicture(anchor, pictureIndex);
        picture.resize(1.0, 1.0);
        return picture;
    }

    private static Map<String, PictureData> getSheetPictures(HSSFSheet sheet) {
        HSSFWorkbook workbook = sheet.getWorkbook();
        List pictures = workbook.getAllPictures();
        if (pictures.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, PictureData> sheetIndexPicMap = new LinkedHashMap<String, PictureData>();
        for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
            HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
            if (!(shape instanceof HSSFPicture)) continue;
            HSSFPicture pic = (HSSFPicture)shape;
            int pictureIndex = pic.getPictureIndex() - 1;
            HSSFPictureData picData = (HSSFPictureData)pictures.get(pictureIndex);
            String picIndex = anchor.getRow1() + "_" + anchor.getCol1();
            sheetIndexPicMap.put(picIndex, (PictureData)picData);
        }
        return sheetIndexPicMap;
    }

    private static Map<Integer, PictureData> getSheetPictures(HSSFRow row) {
        HSSFSheet sheet = row.getSheet();
        HSSFWorkbook workbook = sheet.getWorkbook();
        List pictures = workbook.getAllPictures();
        if (pictures.isEmpty()) {
            return null;
        }
        int resultRowNum = row.getRowNum();
        LinkedHashMap<Integer, PictureData> sheetIndexPicMap = new LinkedHashMap<Integer, PictureData>();
        for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
            HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
            if (!(shape instanceof HSSFPicture) || resultRowNum != anchor.getRow1()) continue;
            HSSFPicture pic = (HSSFPicture)shape;
            int pictureIndex = pic.getPictureIndex() - 1;
            HSSFPictureData picData = (HSSFPictureData)pictures.get(pictureIndex);
            sheetIndexPicMap.put(Integer.valueOf(anchor.getCol1()), (PictureData)picData);
        }
        return sheetIndexPicMap;
    }

    private static Map<String, PictureData> getXSheetPictures(XSSFSheet sheet) {
        List relations = sheet.getRelations();
        if (relations.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, PictureData> sheetIndexPicMap = new LinkedHashMap<String, PictureData>();
        for (POIXMLDocumentPart documentPart : relations) {
            if (!(documentPart instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)documentPart;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture pic = (XSSFPicture)shape;
                XSSFClientAnchor anchor = pic.getPreferredSize();
                CTMarker ctMarker = anchor.getFrom();
                int rowNum = ctMarker.getRow();
                String picIndex = rowNum + "_" + ctMarker.getCol();
                sheetIndexPicMap.put(picIndex, (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }

    private static Map<Integer, PictureData> getXSheetPictures(XSSFRow row) {
        XSSFSheet sheet = row.getSheet();
        List relations = sheet.getRelations();
        if (relations.isEmpty()) {
            return null;
        }
        int resultRowNum = row.getRowNum();
        LinkedHashMap<Integer, PictureData> sheetIndexPicMap = new LinkedHashMap<Integer, PictureData>();
        for (POIXMLDocumentPart documentPart : relations) {
            if (!(documentPart instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)documentPart;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture pic = (XSSFPicture)shape;
                XSSFClientAnchor anchor = pic.getPreferredSize();
                CTMarker ctMarker = anchor.getFrom();
                int rowNum = ctMarker.getRow();
                if (rowNum != resultRowNum) continue;
                sheetIndexPicMap.put(ctMarker.getCol(), (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }
}

