/*
 * Decompiled with CFR 0.152.
 */
package com.geese.plugin.excel;

import com.geese.plugin.excel.ExcelContext;
import com.geese.plugin.excel.ExcelHelper;
import com.geese.plugin.excel.ExcelOperations;
import com.geese.plugin.excel.filter.FilterChain;
import com.geese.plugin.excel.mapping.CellMapping;
import com.geese.plugin.excel.mapping.SheetMapping;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;

public class ExcelOperationsProxy
implements InvocationHandler {
    private ExcelOperations target;

    public ExcelOperationsProxy(ExcelOperations target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        FilterChain filterChain;
        SheetMapping sheetMapping;
        Object mapping;
        FilterChain filterChain2;
        String name = method.getName();
        if (name.startsWith("read")) {
            filterChain2 = null;
            mapping = null;
            if ("readSheet".equals(name)) {
                sheetMapping = (SheetMapping)args[1];
                mapping = args[1];
                filterChain2 = sheetMapping.getExcelMapping().getSheetBeforeReadFilterChain(sheetMapping.getName());
            }
            if ("readRow".equals(name)) {
                sheetMapping = (SheetMapping)args[1];
                mapping = args[1];
                filterChain2 = sheetMapping.getExcelMapping().getRowBeforeReadFilterChain(sheetMapping.getName());
            }
            if (null != filterChain2 && !filterChain2.isEmpty() && !filterChain2.doFilter(args[0], null, mapping, ExcelContext.get())) {
                return "EXCEL_NOT_PASS_FILTERED";
            }
        }
        if (name.startsWith("write")) {
            filterChain2 = null;
            mapping = null;
            if ("writeSheet".equals(name)) {
                mapping = (SheetMapping)args[1];
                filterChain2 = ((SheetMapping)mapping).getExcelMapping().getSheetBeforeWriteFilterChain(((SheetMapping)mapping).getName());
            }
            if ("writeRow".equals(name)) {
                mapping = (SheetMapping)args[1];
                filterChain2 = ((SheetMapping)mapping).getExcelMapping().getRowBeforeWriteFilterChain(((SheetMapping)mapping).getName());
            }
            if (null != filterChain2 && !filterChain2.isEmpty() && !filterChain2.doFilter(args[0], args.length == 3 ? args[2] : null, mapping, ExcelContext.get())) {
                ExcelContext.get().put("EXCEL_NOT_PASS_FILTERED", "EXCEL_NOT_PASS_FILTERED");
                return "EXCEL_NOT_PASS_FILTERED";
            }
        }
        Object returnValue = method.invoke((Object)this.target, args);
        if (name.startsWith("read")) {
            Map<Integer, PictureData> pictureDataMap;
            Cell cell;
            filterChain = null;
            sheetMapping = null;
            if ("readSheet".equals(name)) {
                sheetMapping = (SheetMapping)args[1];
                filterChain = sheetMapping.getExcelMapping().getSheetAfterReadFilterChain(sheetMapping.getName());
            }
            if ("readRow".equals(name)) {
                sheetMapping = (SheetMapping)args[1];
                if (null != args[0]) {
                    this.readPicture((Row)args[0], sheetMapping, (Map)returnValue);
                }
                filterChain = sheetMapping.getExcelMapping().getRowAfterReadFilterChain(sheetMapping.getName());
            }
            if ("readCell".equals(name) && null != (cell = (Cell)args[0]) && null != (pictureDataMap = ExcelHelper.getPictures(cell.getRow())) && !pictureDataMap.isEmpty()) {
                for (Map.Entry<Integer, PictureData> entry : pictureDataMap.entrySet()) {
                    if (entry.getKey().intValue() != cell.getColumnIndex()) continue;
                    returnValue = entry.getValue();
                    break;
                }
            }
            if (null != filterChain && !filterChain.isEmpty() && !filterChain.doFilter(args[0], returnValue, sheetMapping, ExcelContext.get())) {
                return "EXCEL_NOT_PASS_FILTERED";
            }
        }
        if (name.startsWith("write")) {
            Object cellData;
            filterChain = null;
            sheetMapping = null;
            if ("writeSheet".equals(name)) {
                sheetMapping = (SheetMapping)args[1];
                filterChain = sheetMapping.getExcelMapping().getSheetAfterWriteFilterChain(sheetMapping.getName());
            }
            if ("writeRow".equals(name)) {
                sheetMapping = (SheetMapping)args[1];
                this.writePicture((Row)args[0], sheetMapping, (Map)args[2]);
                filterChain = sheetMapping.getExcelMapping().getRowAfterWriteFilterChain(sheetMapping.getName());
            }
            if ("writeCell".equals(name) && null != (cellData = args[2]) && cellData instanceof byte[]) {
                ExcelHelper.setPicture((Cell)args[0], (byte[])cellData);
            }
            if (null != filterChain && !filterChain.isEmpty() && !filterChain.doFilter(args[0], args.length == 3 ? args[2] : null, sheetMapping, ExcelContext.get())) {
                ExcelContext.get().put("EXCEL_NOT_PASS_FILTERED", "EXCEL_NOT_PASS_FILTERED");
                return "EXCEL_NOT_PASS_FILTERED";
            }
        }
        return returnValue;
    }

    private void readPicture(Row row, SheetMapping sheetMapping, Map rowData) {
        Map<Integer, PictureData> collIndexAndPictureDataMap = ExcelHelper.getPictures(row);
        if (null != collIndexAndPictureDataMap && !collIndexAndPictureDataMap.isEmpty()) {
            List<CellMapping> heads = sheetMapping.getTableHeads();
            LinkedHashMap<Integer, String> headIndexAndHeadNameMap = new LinkedHashMap<Integer, String>();
            for (CellMapping cellMapping : heads) {
                headIndexAndHeadNameMap.put(cellMapping.getColumnNumber(), cellMapping.getDataKey());
            }
            for (Map.Entry entry : collIndexAndPictureDataMap.entrySet()) {
                Integer columnIndex = (Integer)entry.getKey();
                String columnName = (String)headIndexAndHeadNameMap.get(columnIndex);
                rowData.put(columnName, ((PictureData)entry.getValue()).getData());
            }
        }
    }

    private void writePicture(Row row, SheetMapping sheetMapping, Map<String, Object> rowData) {
        if (null != row && !rowData.isEmpty()) {
            List<CellMapping> heads = sheetMapping.getTableHeads();
            LinkedHashMap<String, Integer> headNameAndHeadIndexMap = new LinkedHashMap<String, Integer>();
            for (CellMapping cellMapping : heads) {
                headNameAndHeadIndexMap.put(cellMapping.getDataKey(), cellMapping.getColumnNumber());
            }
            for (Map.Entry entry : rowData.entrySet()) {
                Object cellData = entry.getValue();
                if (!(cellData instanceof byte[]) || !headNameAndHeadIndexMap.containsKey(entry.getKey())) continue;
                Integer cellNumber = (Integer)headNameAndHeadIndexMap.get(entry.getKey());
                Cell cell = ExcelHelper.createCell(row, cellNumber);
                ExcelHelper.setPicture(cell, (byte[])cellData);
            }
        }
    }
}

